/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.model;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.TagManager;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.CollectionDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.metadata.StringUtil;
import org.intermine.objectstore.ObjectStoreSummary;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.logic.WebUtil;
import org.intermine.web.logic.config.FieldConfig;
import org.intermine.web.logic.config.FieldConfigHelper;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.WebService;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.output.Output;
import org.intermine.webservice.server.output.PlainFormatter;
import org.intermine.webservice.server.output.StreamedOutput;
import org.json.JSONObject;

public class ModelService
extends WebService {
    private static final String DEFAULT_CALLBACK = "parseModel";
    private static final Logger LOG = Logger.getLogger(ModelService.class);
    private static final String FILE_BASE_NAME = "model";
    private WebConfig config = InterMineContext.getWebConfig();
    private Path node = null;
    private static final String FORMAT_ENDINGS = "^/?(xml|tsv|csv|json|jsonp)$";

    public ModelService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected Output makeXMLOutput(PrintWriter out, String separator) {
        ResponseUtil.setXMLHeader(this.response, "model.xml");
        return new StreamedOutput(out, new PlainFormatter(), separator);
    }

    @Override
    protected Format getDefaultFormat() {
        return Format.XML;
    }

    @Override
    protected void initState() {
        super.initState();
        String pathInfo = StringUtils.defaultString((String)this.request.getPathInfo(), (String)"");
        if (StringUtils.isBlank((String)pathInfo)) {
            return;
        }
        if (pathInfo.matches(FORMAT_ENDINGS)) {
            return;
        }
        this.setFormat(Format.JSON);
        pathInfo = StringUtil.trimSlashes((String)pathInfo).replace('/', '.');
        try {
            Path p;
            HashMap<String, String> subclasses = new HashMap<String, String>();
            Enumeration e = this.request.getParameterNames();
            while (e.hasMoreElements()) {
                String param = (String)e.nextElement();
                subclasses.put(param, this.request.getParameter(param));
            }
            this.node = p = new Path(this.im.getModel(), pathInfo, subclasses);
        }
        catch (PathException e) {
            throw new ResourceNotFoundException("Could not find a node with the id: " + pathInfo);
        }
    }

    @Override
    protected boolean canServe(Format format) {
        return format == Format.XML || format == Format.JSON;
    }

    @Override
    protected void execute() {
        Model model = this.im.getModel();
        if (this.formatIsJSON()) {
            ResponseUtil.setJSONHeader(this.response, "model.json", this.formatIsJSONP());
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            if (this.formatIsJSONP()) {
                String callback = this.getCallback();
                if (callback == null || "".equals(callback)) {
                    callback = DEFAULT_CALLBACK;
                }
                attributes.put("callback", callback);
            }
            if (this.node == null) {
                attributes.put("intro", "\"model\":");
                this.output.setHeaderAttributes(attributes);
                this.output.addResultItem(Arrays.asList(new JSONObject(this.getAnnotatedModel(model)).toString()));
            } else {
                HashMap<String, String> kvPairs = new HashMap<String, String>();
                kvPairs.put("name", ModelService.getNodeName(this.node));
                kvPairs.put("id", this.node.toStringNoConstraints());
                kvPairs.put("display", WebUtil.formatPath(this.node, this.config));
                kvPairs.put("type", "class");
                attributes.put("key_value_pairs", kvPairs);
                attributes.put("intro", "\"fields\":[");
                attributes.put("outro", "]");
                this.output.setHeaderAttributes(attributes);
                this.output.addResultItem(ModelService.nodeChildrenToJSON(this.node));
            }
        } else {
            this.output.addResultItem(Arrays.asList(model.toString()));
        }
    }

    private Map<String, Object> getAnnotatedModel(Model model) {
        TagManager tm = this.im.getTagManager();
        ObjectStoreSummary oss = this.im.getObjectStoreSummary();
        Model.ModelAST modelData = model.toJsonAST();
        Map classes = modelData.getClasses();
        Profile p = this.getPermission().getProfile();
        String userName = p.getUsername();
        try {
            for (Map classData : classes.values()) {
                String className = (String)classData.get("name");
                ClassDescriptor cd = model.getClassDescriptorByName(className);
                classData.put("displayName", WebUtil.formatClass(cd, this.config));
                classData.put("term", cd.getOntologyTerm());
                String fullyQualifiedClassName = cd.getName();
                try {
                    classData.put("count", oss.getClassCount(fullyQualifiedClassName));
                }
                catch (RuntimeException e) {
                    LOG.error((Object)"No class count", (Throwable)e);
                }
                HashSet tags = new HashSet();
                if (p.isLoggedIn()) {
                    tags.addAll(tm.getObjectTagNames(fullyQualifiedClassName, "class", userName));
                }
                tags.addAll(tm.getPublicTagNames(fullyQualifiedClassName, "class"));
                classData.put("tags", tags);
                Object allAttributes = classData.get("attributes");
                HashMap attributes = (HashMap)allAttributes;
                for (Map.Entry entry : attributes.entrySet()) {
                    HashMap attribute = (HashMap)entry.getValue();
                    String attributeName = (String)entry.getKey();
                    AttributeDescriptor fd = cd.getAttributeDescriptorByName(attributeName, true);
                    String displayName = this.getDisplayName(cd, attributeName, (FieldDescriptor)fd);
                    attribute.put("displayName", displayName);
                    attribute.put("term", cd.getOntologyTerm());
                }
                Object allReferences = classData.get("references");
                HashMap refs = (HashMap)allReferences;
                for (Map.Entry entry : refs.entrySet()) {
                    HashMap ref = (HashMap)entry.getValue();
                    String referenceName = (String)entry.getKey();
                    ReferenceDescriptor fd = cd.getReferenceDescriptorByName(referenceName, true);
                    String displayName = this.getDisplayName(cd, referenceName, (FieldDescriptor)fd);
                    ref.put("displayName", displayName);
                }
                Object allCollections = classData.get("collections");
                HashMap collections = (HashMap)allCollections;
                for (Map.Entry entry : collections.entrySet()) {
                    HashMap collection = (HashMap)entry.getValue();
                    String collectionName = (String)entry.getKey();
                    CollectionDescriptor fd = cd.getCollectionDescriptorByName(collectionName, true);
                    String displayName = this.getDisplayName(cd, collectionName, (FieldDescriptor)fd);
                    collection.put("displayName", displayName);
                }
            }
        }
        catch (RuntimeException t) {
            LOG.error((Object)"Could not annotate model", (Throwable)t);
            throw t;
        }
        return modelData;
    }

    private String getDisplayName(ClassDescriptor cd, String fieldName, FieldDescriptor fd) {
        FieldConfig fc;
        String displayName = null;
        if (fd != null && (fc = FieldConfigHelper.getFieldConfig(this.config, cd, fd)) != null) {
            displayName = fc.getDisplayName();
        }
        if (displayName == null) {
            displayName = FieldConfig.getFormattedName(fieldName);
        }
        return displayName;
    }

    private static String getNodeName(Path newNode) {
        WebConfig webConfig = InterMineContext.getWebConfig();
        if (newNode.isRootPath()) {
            return WebUtil.formatPath(newNode, webConfig);
        }
        return WebUtil.formatField(newNode, webConfig);
    }

    private static List<String> nodeChildrenToJSON(Path newNode) {
        LinkedList<String> ret = new LinkedList<String>();
        if (!newNode.endIsAttribute()) {
            ClassDescriptor cd = newNode.getLastClassDescriptor();
            LinkedList fields = new LinkedList();
            fields.addAll(cd.getAllAttributeDescriptors());
            fields.addAll(cd.getAllReferenceDescriptors());
            fields.addAll(cd.getAllCollectionDescriptors());
            for (FieldDescriptor fd : fields) {
                try {
                    ret.add(ModelService.fieldToJSON(newNode.append(fd.getName())));
                }
                catch (PathException e) {
                    throw new ServiceException("While walking model", e);
                }
            }
        }
        return ret;
    }

    private static String fieldToJSON(Path fieldPath) {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"name\":\"" + ModelService.getNodeName(fieldPath) + "\"");
        sb.append(",");
        sb.append("\"id\":\"" + fieldPath.toStringNoConstraints() + "\"");
        if (!fieldPath.endIsAttribute()) {
            sb.append(",\"fields\":true");
            if (fieldPath.endIsCollection()) {
                sb.append(",\"type\":\"collection\"");
            } else {
                sb.append(",\"type\":\"reference\"");
            }
            sb.append(",\"references\":\"" + fieldPath.getLastClassDescriptor().getUnqualifiedName() + "\"");
        } else {
            String type = ((AttributeDescriptor)fieldPath.getEndFieldDescriptor()).getType();
            type = type.substring(type.lastIndexOf(46) + 1);
            sb.append(",\"type\":\"" + type + "\"");
        }
        sb.append("}");
        return sb.toString();
    }
}

