/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.output;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.api.results.ResultElement;
import org.intermine.objectstore.query.Results;

public class FilteringResultIterator
implements Iterator<List<ResultElement>> {
    private static Logger logger = Logger.getLogger(FilteringResultIterator.class);
    private int counter = 0;
    private int start = 0;
    private Integer end = null;
    private String filterTerm = null;
    private List<ResultElement> nextRow = null;
    private final Iterator<Object> subIter;

    public FilteringResultIterator(Results res) {
        this.subIter = res.iterator();
    }

    public FilteringResultIterator(Results res, int start, int size, String filterTerm) {
        this(res);
        this.start = start;
        this.end = start + size;
        this.filterTerm = ObjectUtils.toString((Object)filterTerm).toLowerCase();
        logger.debug((Object)("START: " + start + ", END: " + (start + size) + ", FILTER: " + this.filterTerm));
    }

    @Override
    public boolean hasNext() {
        this.scrollToStart();
        if (this.nextRow != null) {
            return true;
        }
        if (this.counter >= this.start && (this.end == null || this.counter < this.end)) {
            if (StringUtils.isBlank((String)this.filterTerm)) {
                return this.subIter.hasNext();
            }
            try {
                this.nextRow = this.next();
            }
            catch (NoSuchElementException e) {
                return false;
            }
            return this.nextRow != null;
        }
        return false;
    }

    @Override
    public List<ResultElement> next() {
        if (this.nextRow != null) {
            List<ResultElement> ret = this.nextRow;
            this.nextRow = null;
            return ret;
        }
        this.scrollToStart();
        if (this.end != null && this.counter > this.end) {
            throw new NoSuchElementException();
        }
        List<Object> l = null;
        while (l == null) {
            l = this.getNextInternal();
        }
        ++this.counter;
        ArrayList<ResultElement> ret = new ArrayList<ResultElement>();
        for (Object o : l) {
            ResultElement re = new ResultElement(o);
            ret.add(re);
        }
        return ret;
    }

    private void scrollToStart() {
        while (this.counter < this.start && this.subIter.hasNext()) {
            List l = (List)this.subIter.next();
            if (StringUtils.isBlank((String)this.filterTerm)) {
                ++this.counter;
                continue;
            }
            boolean contained = false;
            for (Object o : l) {
                String n = ObjectUtils.toString(o).toLowerCase();
                if (!StringUtils.contains((String)n, (String)this.filterTerm)) continue;
                contained = true;
            }
            if (!contained) continue;
            ++this.counter;
        }
    }

    private List<Object> getNextInternal() {
        String n;
        List l = (List)this.subIter.next();
        if (StringUtils.isBlank((String)this.filterTerm)) {
            return l;
        }
        Object o = l.get(0);
        String string = n = o == null ? "" : o.toString().toLowerCase();
        if (n.indexOf(this.filterTerm) >= 0) {
            return l;
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

