/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.output;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.intermine.webservice.server.output.JSONFormatter;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class JSONResultFormatter
extends JSONFormatter {
    public static final String KEY_VIEWS = "views";
    public static final String KEY_ROOT_CLASS = "rootClass";
    public static final String KEY_MODEL_NAME = "modelName";

    @Override
    protected void formatAttributes(Map<String, Object> attributes, StringBuilder sb) {
        if (sb == null) {
            throw new NullPointerException("sb must not be null");
        }
        if (!(attributes = attributes == null ? new HashMap<String, Object>() : new LinkedHashMap<String, Object>(attributes)).containsKey("intro")) {
            attributes.put("intro", "\"results\":[");
        }
        if (!attributes.containsKey("outro")) {
            attributes.put("outro", "]");
        }
        for (String key : attributes.keySet()) {
            if (RESERVED_KEYS.contains(key)) continue;
            Object val = attributes.get(key);
            sb.append("\"" + key + "\":");
            if (val instanceof List) {
                JSONArray ja = new JSONArray((Collection)((List)val));
                sb.append(ja.toString());
            } else if (val instanceof Map) {
                JSONObject jo = new JSONObject((Map)val);
                sb.append(jo.toString());
            } else {
                sb.append(this.quote(val));
            }
            sb.append(",");
        }
        super.formatAttributes(attributes, sb);
    }

    private String quote(Object o) {
        String sth = StringEscapeUtils.escapeJava((String)String.valueOf(o).trim());
        if (this.attrNeedsQuotes(o, sth)) {
            return "\"" + sth + "\"";
        }
        return sth;
    }

    private boolean attrNeedsQuotes(Object attr, String asString) {
        if (attr == null) {
            return false;
        }
        if (attr instanceof Number) {
            return false;
        }
        return !asString.startsWith("{") && !asString.startsWith("[") && !asString.matches("[-+]?\\d+(\\.\\d+)?");
    }
}

