/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.output;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.intermine.api.results.ResultElement;
import org.intermine.webservice.server.core.ResultProcessor;
import org.intermine.webservice.server.output.Output;

public abstract class JSONResultProcessor
extends ResultProcessor {
    private static final Logger LOG = Logger.getLogger(ResultProcessor.class);

    protected abstract Iterator<? extends Object> getResultsIterator(Iterator<List<ResultElement>> var1);

    @Override
    public void write(Iterator<List<ResultElement>> resultIt, Output output) {
        Iterator<? extends Object> objIter = this.getResultsIterator(resultIt);
        if (!objIter.hasNext()) {
            output.addResultItem(Collections.EMPTY_LIST);
        }
        boolean lastHasComma = false;
        while (objIter.hasNext()) {
            Object next = objIter.next();
            ArrayList<String> outputLine = new ArrayList<String>(Arrays.asList(next.toString()));
            if (objIter.hasNext()) {
                outputLine.add("");
                lastHasComma = true;
            } else {
                lastHasComma = false;
            }
            output.addResultItem(outputLine);
        }
        if (lastHasComma) {
            LOG.error((Object)"Last row has a comma!");
        }
    }
}

