/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.output;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.intermine.api.InterMineAPI;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.api.results.ResultCell;
import org.intermine.api.results.ResultElement;
import org.intermine.pathquery.Path;
import org.intermine.webservice.server.output.TableCellFormatter;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONRowIterator
implements Iterator<JSONArray> {
    private final ExportResultsIterator subIter;
    private final List<Path> viewPaths = new ArrayList<Path>();
    private final TableCellFormatter tableCellFormatter;

    public JSONRowIterator(ExportResultsIterator it, InterMineAPI im) {
        this.subIter = it;
        this.tableCellFormatter = new TableCellFormatter(im);
        this.init();
    }

    private void init() {
        this.viewPaths.addAll(this.subIter.getViewPaths());
    }

    @Override
    public boolean hasNext() {
        return this.subIter.hasNext();
    }

    @Override
    public JSONArray next() {
        List row = this.subIter.next();
        ArrayList<JSONObject> jsonRow = new ArrayList<JSONObject>();
        for (int i = 0; i < row.size(); ++i) {
            ResultElement re = (ResultElement)row.get(i);
            jsonRow.add(this.tableCellFormatter.toJSON((ResultCell)re));
        }
        JSONArray next = new JSONArray(jsonRow);
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported for this implementation");
    }
}

