/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.output;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.intermine.api.results.ResultElement;
import org.intermine.pathquery.ConstraintValueParser;
import org.json.JSONArray;

public class MinimalJsonIterator
implements Iterator<JSONArray> {
    private final Iterator<List<ResultElement>> subIter;

    public MinimalJsonIterator(Iterator<List<ResultElement>> it) {
        this.subIter = it;
    }

    @Override
    public JSONArray next() {
        List<ResultElement> row = this.subIter.next();
        ArrayList<Object> jsonRow = new ArrayList<Object>();
        for (int i = 0; i < row.size(); ++i) {
            ResultElement re = row.get(i);
            if (re == null) {
                jsonRow.add(null);
                continue;
            }
            Object field = re.getField();
            if (field instanceof CharSequence) {
                field = field.toString();
            } else if (field instanceof Date) {
                field = ConstraintValueParser.ISO_DATE_FORMAT.format(field);
            }
            jsonRow.add(field);
        }
        JSONArray next = new JSONArray(jsonRow);
        return next;
    }

    @Override
    public boolean hasNext() {
        return this.subIter.hasNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported for this implementation");
    }
}

