/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.output;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.intermine.api.InterMineAPI;
import org.intermine.api.LinkRedirectManager;
import org.intermine.api.results.ResultCell;
import org.intermine.model.InterMineObject;
import org.intermine.pathquery.ConstraintValueParser;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.logic.PortalHelper;
import org.json.JSONObject;

public class TableCellFormatter {
    private static final String CELL_KEY_URL = "url";
    private static final String CELL_KEY_VALUE = "value";
    private static final String CELL_KEY_CLASS = "class";
    private static final String CELL_KEY_COLUMN = "column";
    private static final String CELL_KEY_ID = "id";
    private final LinkRedirectManager redirector;
    private final InterMineAPI im;
    private Integer maxCellLength;

    public TableCellFormatter(InterMineAPI im) {
        this.im = im;
        this.maxCellLength = Integer.valueOf(InterMineContext.getWebProperties().getProperty("webservice.tablecellformatter.cell.length.max", "200"));
        this.redirector = im.getLinkRedirector();
    }

    public Map<String, Object> toMap(ResultCell cell) {
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        if (cell == null) {
            mapping.put(CELL_KEY_URL, null);
            mapping.put(CELL_KEY_VALUE, null);
            mapping.put(CELL_KEY_COLUMN, null);
        } else {
            CharSequence cs;
            String link = null;
            if (this.redirector != null && cell.getObject() instanceof InterMineObject) {
                link = this.redirector.generateLink(this.im, (InterMineObject)cell.getObject());
            }
            if (link == null) {
                link = PortalHelper.generateReportPath(cell);
            }
            mapping.put(CELL_KEY_URL, link);
            if (cell.getType() == null) {
                mapping.put(CELL_KEY_CLASS, JSONObject.NULL);
            } else {
                mapping.put(CELL_KEY_CLASS, cell.getType());
            }
            if (cell.getId() == null) {
                mapping.put(CELL_KEY_ID, JSONObject.NULL);
            } else {
                mapping.put(CELL_KEY_ID, cell.getId());
            }
            mapping.put(CELL_KEY_COLUMN, cell.getPath().toStringNoConstraints());
            Object raw = cell.getField();
            Object cooked = raw != null && raw instanceof CharSequence ? ((cs = (CharSequence)raw).length() <= this.maxCellLength ? cs.toString() : cs.subSequence(0, this.maxCellLength) + "...") : (raw != null && raw instanceof Date ? ConstraintValueParser.ISO_DATE_FORMAT.format(raw) : raw);
            if (cooked == null) {
                mapping.put(CELL_KEY_VALUE, JSONObject.NULL);
            } else {
                mapping.put(CELL_KEY_VALUE, cooked);
            }
        }
        return mapping;
    }

    public JSONObject toJSON(ResultCell cell) {
        Map<String, Object> mapping = this.toMap(cell);
        JSONObject ret = new JSONObject(mapping);
        return ret;
    }
}

