/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.query;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.intermine.api.InterMineAPI;
import org.intermine.web.context.InterMineContext;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.WebService;
import org.intermine.webservice.server.core.ListManager;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.query.result.PathQueryBuilder;
import org.intermine.webservice.server.query.result.PathQueryBuilderForJSONObj;

public abstract class AbstractQueryService
extends WebService {
    private static final String XML_SCHEMA_LOCATION = "webservice/query.xsd";
    private static final String JSON_SCHEMA_LOCATION = "webservice/query.schema";

    public AbstractQueryService(InterMineAPI im) {
        super(im);
    }

    protected String getSchemaUrl(String queryFormat) {
        return AbstractQueryService.getSchemaLocation(this.request, queryFormat);
    }

    public static String getSchemaLocation(HttpServletRequest request, String queryFormat) {
        String schemaLocation = XML_SCHEMA_LOCATION;
        if ("JSON".equalsIgnoreCase(queryFormat)) {
            schemaLocation = JSON_SCHEMA_LOCATION;
        }
        try {
            Properties webProperties = InterMineContext.getWebProperties();
            String baseUrl = webProperties.getProperty("webapp.baseurl");
            String path = webProperties.getProperty("webapp.path");
            String relPath = path + "/" + schemaLocation;
            URL url = new URL(baseUrl + "/" + relPath);
            return url.toString();
        }
        catch (MalformedURLException e) {
            throw new ServiceException(e);
        }
    }

    protected PathQueryBuilder getQueryBuilder(String input) {
        ListManager listManager = new ListManager(this.im, this.getPermission().getProfile());
        String queryFormat = "XML";
        if (!input.startsWith("<query")) {
            queryFormat = "JSON";
        }
        if (this.formatIsJsonObj() || this.formatIsRDF() || this.formatIsNTriples()) {
            return new PathQueryBuilderForJSONObj(input, this.getSchemaUrl(queryFormat), listManager);
        }
        return new PathQueryBuilder(this.im, input, this.getSchemaUrl(queryFormat), listManager);
    }

    protected boolean formatIsJsonObj() {
        return this.getFormat() == Format.OBJECTS;
    }

    protected boolean formatIsRDF() {
        return this.getFormat() == Format.RDF;
    }

    protected boolean formatIsNTriples() {
        return this.getFormat() == Format.N_TRIPLES;
    }
}

