/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.query;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import org.intermine.api.InterMineAPI;
import org.intermine.api.query.NotPresentException;
import org.intermine.api.query.QueryStoreException;
import org.intermine.pathquery.PathQuery;
import org.intermine.pathquery.PathQueryBinding;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.WebService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;

public class QueryRetrieverService
extends WebService {
    public QueryRetrieverService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected Format getDefaultFormat() {
        return Format.JSON;
    }

    @Override
    protected boolean canServe(Format format) {
        return format == Format.JSON || format == Format.XML;
    }

    @Override
    protected String getDefaultFileName() {
        return "query";
    }

    @Override
    protected void postInit() {
        this.output = null;
    }

    @Override
    protected void execute() {
        PathQuery pq;
        String xml;
        String qid = this.getRequiredParameter("id");
        try {
            xml = this.im.getQueryStore().getQuery(qid);
        }
        catch (NotPresentException e) {
            throw new ResourceNotFoundException(e.getMessage());
        }
        catch (QueryStoreException e) {
            throw new BadRequestException(e.getMessage());
        }
        try {
            pq = PathQueryBinding.unmarshalPathQuery((Reader)new StringReader(xml), (int)2);
        }
        catch (Exception e) {
            throw new BadRequestException(e);
        }
        String ret = this.formatPathQuery(pq);
        PrintWriter pw = this.getRawOutput();
        pw.write(ret);
        pw.flush();
    }

    private String formatPathQuery(PathQuery pq) {
        switch (this.getFormat()) {
            case JSON: {
                return pq.toJson();
            }
            case XML: {
                return pq.toXml();
            }
        }
        throw new IllegalStateException("Only JSON and XML supported");
    }
}

