/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.query;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagManager;
import org.intermine.api.bag.BagQueryRunner;
import org.intermine.api.bag.ClassKeysNotFoundException;
import org.intermine.api.bag.UnknownBagTypeException;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileAlreadyExistsException;
import org.intermine.api.profile.TagManager;
import org.intermine.api.query.MainHelper;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.intermine.CompletelyFalseException;
import org.intermine.objectstore.query.Query;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;
import org.intermine.webservice.server.exceptions.UnauthorizedException;
import org.intermine.webservice.server.lists.ListInput;
import org.intermine.webservice.server.lists.ListServiceUtils;
import org.intermine.webservice.server.query.AbstractQueryService;
import org.intermine.webservice.server.query.QueryRequestParser;
import org.intermine.webservice.server.query.result.PathQueryBuilder;

public class QueryToListService
extends AbstractQueryService {
    private static final String TEMP = "_temp";
    protected final BagManager bagManager;

    public QueryToListService(InterMineAPI im) {
        super(im);
        this.bagManager = im.getBagManager();
    }

    @Override
    protected Format getDefaultFormat() {
        return Format.JSON;
    }

    @Override
    protected boolean canServe(Format format) {
        return format == Format.JSON || format == Format.TEXT;
    }

    @Override
    protected void validateState() {
        if (!this.isAuthenticated()) {
            throw new UnauthorizedException();
        }
        if (!this.getPermission().isRW()) {
            throw new ServiceForbiddenException("This request does not have RW permission");
        }
    }

    @Override
    protected void execute() throws Exception {
        Profile profile = this.getPermission().getProfile();
        ListInput input = new ListInput(this.request, this.bagManager, profile);
        PathQuery pq = this.getQuery(this.request);
        this.generateListFromQuery(pq, input, profile);
    }

    protected PathQuery getQuery(HttpServletRequest request) {
        String xml = new QueryRequestParser(this.im.getQueryStore(), request).getQueryXml();
        if (StringUtils.isEmpty((String)xml)) {
            throw new BadRequestException("query is blank");
        }
        PathQueryBuilder builder = this.getQueryBuilder(xml);
        PathQuery pq = builder.getQuery();
        if (pq.getView().size() != 1) {
            throw new BadRequestException("Queries to the query-to-list service can only have one output column");
        }
        if (!((String)pq.getView().get(0)).endsWith(".id")) {
            throw new BadRequestException("Queries to the query-to-list service must have ids in their view");
        }
        return pq;
    }

    protected void generateListFromQuery(PathQuery pq, ListInput input, Profile profile) throws ObjectStoreException, PathException {
        Query q = this.getQuery(pq, profile);
        String name = input.getListName();
        String tempName = name + TEMP;
        String viewPathString = (String)pq.getView().get(0);
        Path viewPath = pq.makePath(viewPathString);
        String type = viewPath.getLastClassDescriptor().getUnqualifiedName();
        try {
            InterMineBag newList = profile.createBag(tempName, type, input.getDescription(), (Map)this.im.getClassKeys());
            newList.addToBagFromQuery(q);
            this.setHeaderAttributes(name, newList.getSavedBagId());
            try {
                this.im.getBagManager().addTagsToBag(input.getTags(), newList, profile);
            }
            catch (TagManager.TagNameException e) {
                throw new BadRequestException(e.getMessage());
            }
            catch (TagManager.TagNamePermissionException e) {
                throw new ServiceForbiddenException(e.getMessage());
            }
            if (input.doReplace()) {
                ListServiceUtils.ensureBagIsDeleted(profile, input.getListName());
            }
            try {
                profile.renameBag(tempName, name);
            }
            catch (ProfileAlreadyExistsException ex) {
                throw new BadRequestException(ex.getMessage());
            }
            this.output.addResultItem(Arrays.asList("" + newList.size()));
        }
        catch (CompletelyFalseException e) {
            this.output.addResultItem(Arrays.asList("0"));
            throw new BadRequestException("List not created - it would be of size 0");
        }
        catch (UnknownBagTypeException e) {
            this.output.addResultItem(Arrays.asList("0"));
            throw new ServiceException(e.getMessage(), e);
        }
        catch (ClassKeysNotFoundException cke) {
            throw new BadRequestException("Bag has not class key set", cke);
        }
        finally {
            if (profile.getSavedBags().containsKey(tempName)) {
                profile.deleteBag(tempName);
            }
        }
    }

    protected Query getQuery(PathQuery pq, Profile profile) {
        Query ret;
        try {
            ret = MainHelper.makeQuery((PathQuery)pq, (Map)this.bagManager.getBags(profile), new HashMap(), (BagQueryRunner)this.im.getBagQueryRunner(), new HashMap());
        }
        catch (ObjectStoreException e) {
            throw new ServiceException(e);
        }
        return ret;
    }

    protected void setHeaderAttributes(String name, Integer id) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (this.formatIsJSONP()) {
            attributes.put("callback", this.getCallback());
        }
        if (this.formatIsJSON()) {
            attributes.put("intro", "\"listSize\":");
        }
        HashMap<String, String> kvPairs = new HashMap<String, String>();
        kvPairs.put("listName", name);
        kvPairs.put("listId", "" + id);
        attributes.put("key_value_pairs", kvPairs);
        this.output.setHeaderAttributes(attributes);
    }
}

