/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.query;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.SavedQuery;
import org.intermine.pathquery.PathQuery;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.query.QueryUploadService;

public class QueryUpdateService
extends QueryUploadService {
    public QueryUpdateService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected Map<String, String> saveQueries(Map<String, PathQuery> toSave) {
        HashMap<String, String> retval = new HashMap<String, String>();
        for (Map.Entry<String, PathQuery> pair : toSave.entrySet()) {
            String name = pair.getKey();
            SavedQuery previousState = (SavedQuery)this.profile.getSavedQueries().get(pair.getKey());
            try {
                this.profile.saveQuery(name, new SavedQuery(name, new Date(), pair.getValue()));
                retval.put(name, name);
            }
            catch (Exception e) {
                try {
                    if (previousState != null) {
                        this.profile.saveQuery(pair.getKey(), previousState);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ServiceException("Could not save query " + pair.getKey(), e);
            }
        }
        return retval;
    }
}

