/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.query;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagManager;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileManager;
import org.intermine.metadata.Model;
import org.intermine.pathquery.PathQuery;
import org.intermine.pathquery.PathQueryBinding;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.WebService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;
import org.intermine.webservice.server.output.Formatter;
import org.intermine.webservice.server.output.Output;
import org.intermine.webservice.server.output.StreamedOutput;

public class QueryUploadService
extends WebService {
    public static final String QUERIES_PARAMETER = "xml";
    public static final String VERSION_PARAMETER = "version";
    private static final Logger LOG = Logger.getLogger(QueryUploadService.class);
    private Map<String, InterMineBag> lists;
    private final Set<String> knownBags = new HashSet<String>();
    private final List<String> problems = new ArrayList<String>();
    protected Profile profile;

    public QueryUploadService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected Format getDefaultFormat() {
        return Format.TEXT;
    }

    @Override
    protected boolean canServe(Format f) {
        return f == Format.JSON || f == Format.XML || f == Format.TEXT || f == Format.TSV || f == Format.CSV;
    }

    @Override
    protected void postInit() {
        this.profile = this.getPermission().getProfile();
        BagManager bagManager = this.im.getBagManager();
        this.lists = bagManager.getBags(this.profile);
        this.knownBags.addAll(this.lists.keySet());
        this.output.setHeaderAttributes(this.getHeaderAttributes());
    }

    private Map<String, Object> getHeaderAttributes() {
        HashMap<String, Object> headerAttributes = new HashMap<String, Object>();
        switch (this.getFormat()) {
            case JSON: {
                headerAttributes.put("intro", "\"queries\":{");
                headerAttributes.put("outro", "}");
                break;
            }
        }
        return headerAttributes;
    }

    @Override
    protected void validateState() {
        if (this.getPermission().getLevel() == ProfileManager.ApiPermission.Level.RO) {
            throw new ServiceForbiddenException("Access denied.");
        }
    }

    @Override
    protected void execute() throws Exception {
        Map queries;
        String queriesString = this.getQueryString();
        HashMap<String, PathQuery> toSave = new HashMap<String, PathQuery>();
        int version = this.getVersion();
        StringReader r = new StringReader(queriesString);
        try {
            queries = queriesString.startsWith("<") ? PathQueryBinding.unmarshalPathQueries((Reader)r, (int)version) : PathQueryBinding.unmarshalJSONPathQueries((Reader)r, (Model)this.im.getModel());
        }
        catch (Exception e) {
            throw new BadRequestException("Could not de-serialize queries: " + e.getMessage());
        }
        for (String name : queries.keySet()) {
            PathQuery pq = (PathQuery)queries.get(name);
            pq.setTitle(name);
            if (!pq.isValid()) {
                this.problems.add(name + ": " + this.formatMessage(pq.verifyQuery()));
                continue;
            }
            HashSet<String> missingBags = new HashSet<String>();
            for (String bag : pq.getBagNames()) {
                if (this.knownBags.contains(bag)) continue;
                missingBags.add(bag);
            }
            if (missingBags.isEmpty()) {
                toSave.put(name, pq);
                continue;
            }
            this.problems.add(name + " references the following missing lists: " + missingBags);
        }
        if (toSave.size() != queries.size()) {
            throw new BadRequestException("Errors with queries. " + StringUtils.join(this.problems, (String)"\n"));
        }
        try {
            Map<String, String> saved = this.saveQueries(toSave);
            Iterator<Map.Entry<String, String>> it = saved.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> pair = it.next();
                this.addResultItem(pair, it.hasNext());
            }
        }
        catch (Exception e) {
            throw new ServiceException("Failed to save queries", e);
        }
    }

    protected Map<String, String> saveQueries(Map<String, PathQuery> toSave) {
        return this.profile.saveQueries(toSave);
    }

    private void addResultItem(Map.Entry<String, String> mapping, boolean hasMore) {
        switch (this.getFormat()) {
            case JSON: {
                List<String> line = Arrays.asList(String.format("\"%s\":\"%s\"", StringEscapeUtils.escapeJava((String)mapping.getKey()), StringEscapeUtils.escapeJava((String)mapping.getValue())));
                if (hasMore) {
                    line.add("");
                }
                this.output.addResultItem(line);
                break;
            }
            case TEXT: {
                this.output.addResultItem(Arrays.asList(String.format("%s successfully saved as %s", mapping.getKey(), mapping.getValue())));
                break;
            }
            default: {
                this.output.addResultItem(Arrays.asList(mapping.getKey(), mapping.getValue()));
            }
        }
    }

    protected String getQueryString() throws IOException {
        String queriesString;
        String contentType = StringUtils.defaultString((String)this.request.getContentType(), (String)"").trim();
        if (contentType.contains(";")) {
            String[] parts = contentType.split(";", 2);
            contentType = parts[0].trim();
        }
        LOG.debug((Object)("Reading queries from " + contentType + " data"));
        if ("application/xml".equals(contentType) || "text/xml".equals(contentType)) {
            ServletInputStream in = this.request.getInputStream();
            queriesString = IOUtils.toString((InputStream)in);
        } else if ("application/json".equals(contentType) || "text/json".equals(contentType)) {
            ServletInputStream in = this.request.getInputStream();
            queriesString = IOUtils.toString((InputStream)in);
        } else {
            queriesString = this.getRequiredParameter("query");
        }
        return queriesString;
    }

    private String formatMessage(List<String> msgs) {
        StringBuilder sb = new StringBuilder();
        for (String msg : msgs) {
            sb.append(msg);
            if (msg.endsWith(".")) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    private Integer getVersion() {
        return this.getIntParameter(VERSION_PARAMETER, 2);
    }

    @Override
    protected Output makeXMLOutput(PrintWriter out, String separator) {
        ResponseUtil.setXMLHeader(this.response, "uploaded-queries.xml");
        try {
            return new StreamedOutput(out, new XMLFormatter(out), separator);
        }
        catch (XMLStreamException e) {
            throw new ServiceException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new ServiceException(e);
        }
    }

    private static class XMLFormatter
    extends Formatter {
        private XMLStreamWriter writer;

        XMLFormatter(PrintWriter output) throws XMLStreamException {
            this.writer = XMLOutputFactory.newInstance().createXMLStreamWriter(output);
        }

        @Override
        public String formatHeader(Map<String, Object> attributes) {
            try {
                this.writer.writeStartElement("report");
            }
            catch (XMLStreamException e) {
                throw new ServiceException(e);
            }
            return "";
        }

        @Override
        public String formatResult(List<String> resultRow) {
            try {
                this.writer.writeStartElement("entry");
                this.writer.writeStartElement("input");
                this.writer.writeCharacters(resultRow.get(0));
                this.writer.writeEndElement();
                this.writer.writeStartElement("saved-as");
                this.writer.writeCharacters(resultRow.get(1));
                this.writer.writeEndElement();
                this.writer.writeEndElement();
            }
            catch (XMLStreamException e) {
                throw new ServiceException(e);
            }
            return "";
        }

        @Override
        public String formatFooter(String errorMessage, int errorCode) {
            try {
                if (errorMessage != null && errorCode >= 400) {
                    this.writer.writeStartElement("error");
                    this.writer.writeAttribute("code", String.valueOf(errorCode));
                    this.writer.writeStartElement("message");
                    this.writer.writeCharacters(errorMessage);
                    this.writer.writeEndElement();
                    this.writer.writeEndElement();
                }
                this.writer.writeEndElement();
            }
            catch (XMLStreamException e) {
                throw new ServiceException(e);
            }
            return "";
        }
    }
}

