/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.query;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.SavedQuery;
import org.intermine.pathquery.PathQuery;
import org.intermine.pathquery.PathQueryBinding;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.core.Predicate;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.output.Output;
import org.intermine.webservice.server.output.PlainFormatter;
import org.intermine.webservice.server.output.StreamedOutput;
import org.json.JSONException;
import org.json.JSONObject;

public class SavedQueryRetrievalService
extends JSONService {
    public SavedQueryRetrievalService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected boolean canServe(Format format) {
        switch (format) {
            case XML: 
            case JSON: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Output makeXMLOutput(PrintWriter out, String separator) {
        ResponseUtil.setXMLHeader(this.response, "saved-queries.xml");
        return new StreamedOutput(out, new PlainFormatter(), separator);
    }

    @Override
    protected void execute() {
        Profile p = this.getPermission().getProfile();
        Predicate<String> filter = this.getFilter(this.getOptionalParameter("filter", ""));
        Map<String, SavedQuery> queries = this.getQueries(filter, p.getSavedQueries());
        if (Format.JSON == this.getFormat()) {
            this.sendJSON(queries);
        } else {
            this.sendXML(queries);
        }
    }

    private void sendXML(Map<String, SavedQuery> queries) {
        int version = this.im.getProfileManager().getVersion();
        try {
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(this.getRawOutput());
            writer.writeStartElement("saved-queries");
            for (Map.Entry<String, SavedQuery> pair : queries.entrySet()) {
                PathQuery pq = pair.getValue().getPathQuery();
                PathQueryBinding.marshal((PathQuery)pq, (String)pair.getKey(), (String)pq.getModel().getName(), (XMLStreamWriter)writer, (int)version);
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new ServiceException("Serialization error.", e);
        }
    }

    private void sendJSON(Map<String, SavedQuery> queries) {
        JSONObject result = new JSONObject();
        try {
            for (Map.Entry<String, SavedQuery> pair : queries.entrySet()) {
                SavedQuery sq = pair.getValue();
                Date dateCreated = sq.getDateCreated();
                result.put(pair.getKey(), (Object)new JSONObject(sq.getPathQuery().toJson(dateCreated)));
            }
            this.output.addResultItem(Arrays.asList(result.toString(0)));
        }
        catch (JSONException e) {
            throw new ServiceException("Serialization error.", e);
        }
    }

    private Map<String, SavedQuery> getQueries(Predicate<String> filter, Map<String, SavedQuery> allSaved) {
        HashMap<String, SavedQuery> queries = new HashMap<String, SavedQuery>();
        for (Map.Entry<String, SavedQuery> pair : allSaved.entrySet()) {
            SavedQuery q = pair.getValue();
            if (!((Boolean)filter.call((Object)pair.getKey())).booleanValue()) continue;
            queries.put(pair.getKey(), q);
        }
        return queries;
    }

    private Predicate<String> getFilter(String filter) {
        if (StringUtils.isBlank((String)(filter = filter.trim())) || "*".equals(filter)) {
            return new AlwaysTrue();
        }
        String noStars = filter.replaceAll("(^\\*|\\*$)", "");
        if (StringUtils.isBlank((String)noStars)) {
            throw new BadRequestException("Illegal filter string");
        }
        if (filter.startsWith("*")) {
            if (filter.endsWith("*")) {
                return new Contains(noStars);
            }
            return new EndsWith(noStars);
        }
        if (filter.endsWith("*")) {
            return new StartsWith(noStars);
        }
        return new Matches(noStars);
    }

    @Override
    public String getResultsKey() {
        return "queries";
    }

    private class Matches
    implements Predicate<String> {
        private final String target;

        Matches(String target) {
            this.target = target;
        }

        @Override
        public Boolean call(String subject) {
            return subject != null && subject.equalsIgnoreCase(this.target);
        }
    }

    private class StartsWith
    implements Predicate<String> {
        private final String target;

        StartsWith(String target) {
            this.target = target.toLowerCase();
        }

        @Override
        public Boolean call(String subject) {
            return subject != null && subject.toLowerCase().startsWith(this.target);
        }
    }

    private class EndsWith
    implements Predicate<String> {
        private final String target;

        EndsWith(String target) {
            this.target = target.toLowerCase();
        }

        @Override
        public Boolean call(String subject) {
            return subject != null && subject.toLowerCase().endsWith(this.target);
        }
    }

    private class Contains
    implements Predicate<String> {
        private final String target;

        Contains(String target) {
            this.target = target.toLowerCase();
        }

        @Override
        public Boolean call(String subject) {
            return subject != null && subject.toLowerCase().contains(this.target);
        }
    }

    private class AlwaysTrue
    implements Predicate<String> {
        private AlwaysTrue() {
        }

        @Override
        public Boolean call(String subject) {
            return true;
        }
    }
}

