/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.query.result;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.intermine.api.config.ClassKeyHelper;
import org.intermine.api.query.PathQueryExecutor;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.api.results.ResultElement;
import org.intermine.api.types.ClassKeys;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.Model;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.OrderElement;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathLengthComparator;
import org.intermine.pathquery.PathQuery;
import org.intermine.pathquery.PathQueryBinding;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.logic.WebUtil;
import org.intermine.web.util.URLGenerator;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.query.result.QueryResultLinkGenerator;

public class FrictionlessDataPackage {
    protected LinkedHashMap<String, Object> dataPackageAttributes = new LinkedHashMap();
    protected static final String DATAPACKAGE_FILENAME = "datapackage.json";

    protected void exportDataPackage(PathQuery pq, HttpServletRequest request, PathQueryExecutor executor, String format) {
        block14: {
            String clsName;
            try {
                clsName = pq.getRootClass();
            }
            catch (PathException e1) {
                throw new ServiceException(e1);
            }
            ArrayList fields = new ArrayList();
            for (String v : pq.getView()) {
                try {
                    LinkedHashMap<String, String> columnDetails = new LinkedHashMap<String, String>();
                    Path p = pq.makePath(v);
                    AttributeDescriptor ad = (AttributeDescriptor)p.getEndFieldDescriptor();
                    String type = ad.getType();
                    int lastIndexOfDot = type.lastIndexOf(46);
                    type = type.substring(lastIndexOfDot + 1);
                    String friendlyPath = WebUtil.formatPathDescription(v, pq, InterMineContext.getWebConfig());
                    columnDetails.put("name", p.getLastElement());
                    columnDetails.put("type", type);
                    columnDetails.put("class path", friendlyPath);
                    columnDetails.put("class ontology link", p.getLastClassDescriptor().getOntologyTerm());
                    columnDetails.put("attribute ontology link", ((AttributeDescriptor)p.getEndFieldDescriptor()).getOntologyTerm());
                    fields.add(columnDetails);
                }
                catch (PathException e) {
                    throw new ServiceException(e);
                }
            }
            LinkedHashMap<String, List<Object>> schema = new LinkedHashMap<String, List<Object>>();
            schema.put("fields", fields);
            schema.put("primaryKey", this.getPrimaryKeys(pq, clsName));
            String xml = this.getQueryXML(null, pq);
            String serviceFormat = request.getParameter("serviceFormat") != null ? request.getParameter("serviceFormat") : "tab";
            String link = new QueryResultLinkGenerator().getLink(new URLGenerator(request).getPermanentBaseURL(), xml, serviceFormat);
            String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            String mineName = InterMineContext.getWebProperties().getProperty("webapp.path");
            String mineVersion = InterMineContext.getWebProperties().getProperty("project.releaseVersion");
            LinkedHashMap<String, Object> resource = new LinkedHashMap<String, Object>();
            resource.put("profile", "tabular-data-resource");
            resource.put("name", mineName + "-query-data-resource");
            resource.put("path", link);
            resource.put("format", format);
            resource.put("timestamp", timestamp);
            resource.put("schema", schema);
            ArrayList<LinkedHashMap<String, Object>> resources = new ArrayList<LinkedHashMap<String, Object>>();
            resources.add(resource);
            ArrayList dataSources = new ArrayList();
            this.dataPackageAttributes.put("profile", "tabular-data-package");
            this.dataPackageAttributes.put("name", mineName + "@v" + mineVersion);
            this.dataPackageAttributes.put("resources", resources);
            try {
                ExportResultsIterator results;
                PathQuery cloneQuery = pq.clone();
                PathQuery newPq = FrictionlessDataPackage.processQuery(cloneQuery);
                List originalViews = pq.getView();
                ArrayList<Path> viewPaths = new ArrayList<Path>();
                for (String v : originalViews) {
                    try {
                        viewPaths.add(pq.makePath(v));
                    }
                    catch (PathException e) {
                        throw new RuntimeException("Problem making path " + v, e);
                    }
                }
                String namePath = ((Path)viewPaths.get(0)).getStartClassDescriptor().getUnqualifiedName() + ".dataSets.dataSource.name";
                if (!((Path)viewPaths.get(0)).getStartClassDescriptor().getAllSuperclassNames().contains("org.intermine.model.bio.BioEntity")) break block14;
                Results nameList = executor.summariseQuery(newPq, namePath, true);
                PathQuery dataSourceQuery = new PathQuery(Model.getInstanceByName((String)"genomic"));
                dataSourceQuery.addViews(new String[]{"DataSource.name", "DataSource.url"});
                String constraintLogic = "";
                ArrayList<String> simpleList = new ArrayList<String>();
                for (int i = 0; i < nameList.size(); ++i) {
                    String name = ((ResultsRow)nameList.get(i)).get(0).toString();
                    dataSourceQuery.addConstraint((PathConstraint)Constraints.eq((String)"DataSource.name", (String)name), String.valueOf(Character.toChars(i + 65)));
                    simpleList.add(name);
                    constraintLogic = i < nameList.size() - 1 ? constraintLogic + String.valueOf(Character.toChars(i + 65)) + " OR " : constraintLogic + String.valueOf(Character.toChars(i + 65));
                }
                dataSourceQuery.setConstraintLogic(constraintLogic);
                try {
                    results = executor.execute(dataSourceQuery);
                }
                catch (ObjectStoreException e) {
                    throw new RuntimeException(e);
                }
                while (results.hasNext()) {
                    List item = results.next();
                    String sourceName = ((ResultElement)item.get(0)).getField().toString();
                    if (!simpleList.contains(sourceName)) continue;
                    LinkedHashMap<String, String> tempDataSource = new LinkedHashMap<String, String>();
                    tempDataSource.put("title", sourceName);
                    tempDataSource.put("url", ((ResultElement)item.get(1)).getField() != null ? ((ResultElement)item.get(1)).getField().toString() : "null");
                    dataSources.add(tempDataSource);
                }
                this.dataPackageAttributes.put("sources", dataSources);
            }
            catch (ObjectStoreException e) {
                throw new ServiceException(e);
            }
        }
    }

    private List<String> getPrimaryKeys(PathQuery pq, String clsName) {
        Properties props = new Properties();
        try {
            props.load(this.getClass().getClassLoader().getResourceAsStream("class_keys.properties"));
        }
        catch (IOException e1) {
            throw new ServiceException(e1);
        }
        ClassKeys classKeys = ClassKeyHelper.readKeys((Model)pq.getModel(), (Properties)props);
        List keys = ClassKeyHelper.getKeyFieldNames((Map)classKeys, (String)clsName);
        return keys;
    }

    private String getQueryXML(String name, PathQuery query) {
        String modelName = query.getModel().getName();
        return PathQueryBinding.marshal((PathQuery)query, (String)(name != null ? name : ""), (String)modelName, (int)2);
    }

    public static PathQuery processQuery(PathQuery beforeChanges) {
        PathQuery afterChanges = beforeChanges.clone();
        afterChanges.clearView();
        afterChanges.clearOrderBy();
        List<String> newViews = FrictionlessDataPackage.getAlteredViews(beforeChanges);
        afterChanges.addOrderBy(new OrderElement(newViews.get(0), OrderDirection.ASC));
        afterChanges.addViews(newViews);
        return afterChanges;
    }

    public static List<String> getAlteredViews(PathQuery pq) {
        List originalViews = pq.getView();
        ArrayList<Path> viewPaths = new ArrayList<Path>();
        for (String v : originalViews) {
            try {
                viewPaths.add(pq.makePath(v));
            }
            catch (PathException e) {
                throw new RuntimeException("Problem making path " + v, e);
            }
        }
        Collections.sort(viewPaths, PathLengthComparator.getInstance());
        ArrayList<String> newViews = new ArrayList<String>();
        String namePath = ((Path)viewPaths.get(0)).getStartClassDescriptor().getUnqualifiedName() + ".dataSets.dataSource.name";
        String urlPath = ((Path)viewPaths.get(0)).getStartClassDescriptor().getUnqualifiedName() + ".dataSets.dataSource.url";
        newViews.add(0, namePath);
        newViews.add(1, urlPath);
        return newViews;
    }
}

