/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.query.result;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.BagState;
import org.intermine.api.profile.InterMineBag;
import org.intermine.metadata.Model;
import org.intermine.pathquery.PathQuery;
import org.intermine.pathquery.PathQueryBinding;
import org.intermine.webservice.server.core.Producer;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.query.result.XMLValidator;
import org.json.JSONObject;
import org.json.JSONTokener;

public class PathQueryBuilder {
    private PathQuery pathQuery;
    private static Logger logger = Logger.getLogger(PathQueryBuilder.class);
    private static final Logger LOG = Logger.getLogger(PathQueryBuilder.class);

    PathQueryBuilder() {
    }

    public PathQueryBuilder(InterMineAPI im, String input, String schemaUrl, Producer<Map<String, InterMineBag>> bagSource) {
        if (input.startsWith("<query")) {
            this.buildXMLQuery(input, schemaUrl, bagSource);
        } else {
            this.buildJSONQuery(im, input, schemaUrl, bagSource);
        }
    }

    private void buildJSONQuery(InterMineAPI im, String jsonQuery, String schemaUrl, Producer<Map<String, InterMineBag>> bagSource) {
        try {
            LOG.info((Object)("Using the schemaUrl " + schemaUrl));
            URL schemaLocation = new URL(schemaUrl);
            InputStreamReader schemaReader = new InputStreamReader(schemaLocation.openStream());
            JSONObject rawSchema = new JSONObject(new JSONTokener((Reader)schemaReader));
            Schema schema = SchemaLoader.load((JSONObject)rawSchema);
            schema.validate((Object)new JSONObject(jsonQuery));
            this.pathQuery = PathQueryBinding.unmarshalJSONPathQuery((Model)im.getModel(), (String)jsonQuery);
        }
        catch (ValidationException e) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append(e.getMessage());
            ListIterator errors = e.getCausingExceptions().listIterator();
            while (errors.hasNext()) {
                errorMessage.append(errors.next());
            }
            throw new BadRequestException(errorMessage.toString());
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
        if (!this.pathQuery.isValid()) {
            throw new BadRequestException("JSON is well formatted but query contains errors:\n" + this.formatMessage(this.pathQuery.verifyQuery()));
        }
        this.checkBags(bagSource);
    }

    private void checkBags(Producer<Map<String, InterMineBag>> bagSource) {
        HashSet<String> missingBags = new HashSet<String>();
        HashSet<String> toUpgrade = new HashSet<String>();
        for (String bagName : this.pathQuery.getBagNames()) {
            Map<String, InterMineBag> savedBags = bagSource.produce();
            if (!savedBags.containsKey(bagName)) {
                missingBags.add(bagName);
                continue;
            }
            InterMineBag bag = savedBags.get(bagName);
            if (BagState.CURRENT == BagState.valueOf((String)bag.getState())) continue;
            toUpgrade.add(bagName);
        }
        if (!missingBags.isEmpty()) {
            throw new BadRequestException("The query is well formatted but you do not have access to the following mentioned lists:\n" + this.formatMessage(missingBags));
        }
        if (!toUpgrade.isEmpty()) {
            throw new ServiceException("The query is well formatted, but the following lists are not 'current', and need to be manually upgraded:\n" + this.formatMessage(toUpgrade));
        }
    }

    void buildXMLQuery(String xml, String schemaUrl, Producer<Map<String, InterMineBag>> bagSource) {
        XMLValidator validator = new XMLValidator();
        validator.validate(xml, schemaUrl);
        if (validator.getErrorsAndWarnings().size() == 0) {
            try {
                this.pathQuery = PathQueryBinding.unmarshalPathQuery((Reader)new StringReader(xml), (int)2);
            }
            catch (Exception e) {
                String message = String.format("XML is not well formatted. Got %s.", xml);
                throw new BadRequestException(message, e);
            }
            if (!this.pathQuery.isValid()) {
                throw new BadRequestException("XML is well formatted but query contains errors:\n" + this.formatMessage(this.pathQuery.verifyQuery()));
            }
        } else {
            logger.debug((Object)("Received invalid xml: " + xml));
            throw new BadRequestException("Query does not pass XML validation. " + this.formatMessage(validator.getErrorsAndWarnings()));
        }
        this.checkBags(bagSource);
    }

    private String formatMessage(Collection<String> msgs) {
        StringBuilder sb = new StringBuilder();
        for (String msg : msgs) {
            sb.append(msg);
            if (!msg.endsWith(".")) {
                sb.append(".");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public PathQuery getQuery() {
        return this.pathQuery;
    }
}

