/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.query.result;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intermine.api.profile.InterMineBag;
import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.OrderElement;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathLengthComparator;
import org.intermine.pathquery.PathQuery;
import org.intermine.webservice.server.core.Producer;
import org.intermine.webservice.server.query.result.PathQueryBuilder;

public class PathQueryBuilderForJSONObj
extends PathQueryBuilder {
    protected PathQueryBuilderForJSONObj() {
    }

    public PathQueryBuilderForJSONObj(String xml, String schemaUrl, Producer<Map<String, InterMineBag>> savedBags) {
        super(null, xml, schemaUrl, savedBags);
    }

    @Override
    public PathQuery getQuery() {
        PathQuery beforeChanges = super.getQuery();
        return PathQueryBuilderForJSONObj.processQuery(beforeChanges);
    }

    public static PathQuery processQuery(PathQuery beforeChanges) {
        PathQuery afterChanges = beforeChanges.clone();
        afterChanges.clearView();
        afterChanges.clearOrderBy();
        List<String> newViews = PathQueryBuilderForJSONObj.getAlteredViews(beforeChanges);
        afterChanges.addOrderBy(new OrderElement(newViews.get(0), OrderDirection.ASC));
        afterChanges.addViews(newViews);
        try {
            String string = afterChanges.getRootClass();
        }
        catch (PathException e) {
            Pattern pattern = Pattern.compile("Path\\s(.*?)\\sin\\sview\\slist");
            Matcher matcher = pattern.matcher(e.toString());
            while (matcher.find()) {
                String badPath = matcher.group(1);
                afterChanges.removeView(badPath);
                afterChanges.removeOrderBy(badPath);
            }
            afterChanges.addOrderBys((Collection)beforeChanges.getOrderBy());
        }
        return afterChanges;
    }

    public static List<String> getAlteredViews(PathQuery pq) {
        List originalViews = pq.getView();
        ArrayList<Path> viewPaths = new ArrayList<Path>();
        for (String v : originalViews) {
            try {
                viewPaths.add(pq.makePath(v));
            }
            catch (PathException e) {
                throw new RuntimeException("Problem making path " + v, e);
            }
        }
        Collections.sort(viewPaths, PathLengthComparator.getInstance());
        ArrayList<String> newViews = new ArrayList<String>();
        HashSet<Path> classesWithAttributes = new HashSet<Path>();
        String idPath = ((Path)viewPaths.get(0)).getStartClassDescriptor().getUnqualifiedName() + ".id";
        for (Path p : viewPaths) {
            if (!p.endIsAttribute()) {
                throw new RuntimeException("The view can only contain attribute paths - Got: '" + p.toStringNoConstraints() + "'");
            }
            newViews.addAll(PathQueryBuilderForJSONObj.getNewViewStrings(classesWithAttributes, p));
        }
        int idPos = newViews.indexOf(idPath);
        if (idPos != 0) {
            if (idPos > 0) {
                newViews.remove(idPos);
            }
            newViews.add(0, idPath);
        }
        return newViews;
    }

    private static List<String> getNewViewStrings(Set<Path> classesWithAttributes, Path p) {
        classesWithAttributes.add(p.getPrefix());
        List composingPaths = p.decomposePath();
        ArrayList<String> newParts = new ArrayList<String>();
        for (Path cp : composingPaths) {
            if (cp.endIsAttribute() || classesWithAttributes.contains(cp)) continue;
            newParts.add(PathQueryBuilderForJSONObj.getNewAttributeNode(classesWithAttributes, cp));
        }
        newParts.add(p.toStringNoConstraints());
        return newParts;
    }

    static String getNewAttributeNode(Set<Path> classesWithAttributes, Path p) {
        String retVal;
        try {
            retVal = p.append("id").toStringNoConstraints();
            classesWithAttributes.add(p);
        }
        catch (PathException e) {
            throw new RuntimeException("Couldn't extend " + p.toStringNoConstraints() + " with 'id'", e);
        }
        return retVal;
    }
}

