/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.query.result;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.InvokerTransformer;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagQueryRunner;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.BagNotFound;
import org.intermine.api.query.MainHelper;
import org.intermine.api.query.PathQueryExecutor;
import org.intermine.api.results.ResultCell;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.Results;
import org.intermine.pathquery.PathQuery;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.core.Either;
import org.intermine.webservice.server.core.EitherVisitor;
import org.intermine.webservice.server.core.Page;
import org.intermine.webservice.server.core.SubTable;
import org.intermine.webservice.server.core.TableRowIterator;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.output.TableCellFormatter;
import org.intermine.webservice.server.query.result.QueryResultService;
import org.json.JSONArray;

public class TableRowService
extends QueryResultService {
    public TableRowService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected Format getDefaultFormat() {
        return Format.JSON;
    }

    @Override
    protected boolean canServe(Format format) {
        return format == Format.JSON;
    }

    @Override
    protected void setHeaderAttributes(PathQuery pq, Integer start, Integer size) {
        try {
            Profile p = this.getPermission().getProfile();
            PathQueryExecutor pqe = this.im.getPathQueryExecutor(p);
            int count = pqe.count(pq);
            this.attributes.put("iTotalRecords", count);
        }
        catch (BagNotFound e) {
            throw new BadRequestException(e.getMessage());
        }
        catch (ObjectStoreException e) {
            throw new ServiceException("Error counting rows.", e);
        }
        super.setHeaderAttributes(pq, start, size);
    }

    @Override
    public void runPathQuery(PathQuery pathQuery, int firstResult, int maxResults) {
        Query q;
        ObjectStore os = this.im.getObjectStore();
        Profile p = this.getPermission().getProfile();
        HashMap<String, QuerySelectable> pathToQueryNode = new HashMap<String, QuerySelectable>();
        try {
            q = MainHelper.makeQuery((PathQuery)pathQuery, (Map)this.im.getBagManager().getCurrentBags(p), pathToQueryNode, (BagQueryRunner)this.im.getBagQueryRunner(), new HashMap());
        }
        catch (ObjectStoreException e) {
            throw new ServiceException("Could not run query", e);
        }
        Results results = os.execute(q, 5000, true, false, false);
        Page page = new Page(firstResult, maxResults == 0 ? null : Integer.valueOf(maxResults));
        Query realQ = results.getQuery();
        if (realQ == q) {
            this.getPathQueryExecutor().updateQueryToPathToQueryNode(q, pathToQueryNode);
        }
        TableRowIterator iter = new TableRowIterator(pathQuery, q, results, pathToQueryNode, page, this.im);
        Processor processor = new Processor(this.im);
        while (iter.hasNext()) {
            LinkedList<Map<String, Object>> rowdata = new LinkedList<Map<String, Object>>();
            Iterator iterator = iter.next().iterator();
            while (iterator.hasNext()) {
                Either cell = (Either)iterator.next();
                rowdata.add(cell.accept(processor));
            }
            JSONArray ja = new JSONArray(rowdata);
            if (iter.hasNext()) {
                this.output.addResultItem(Arrays.asList(ja.toString(), ""));
                continue;
            }
            this.output.addResultItem(Arrays.asList(ja.toString()));
        }
    }

    private static final class Processor
    extends EitherVisitor<ResultCell, SubTable, Map<String, Object>> {
        private static final String CELL_KEY_COLUMN = "column";
        private static final String CELL_KEY_VIEW = "view";
        private static final String CELL_KEY_ROWS = "rows";
        private TableCellFormatter tableCellFormatter;

        Processor(InterMineAPI im) {
            this.tableCellFormatter = new TableCellFormatter(im);
        }

        @Override
        public Map<String, Object> visitLeft(ResultCell a) {
            return this.tableCellFormatter.toMap(a);
        }

        @Override
        public Map<String, Object> visitRight(SubTable b) {
            HashMap<String, Object> cell = new HashMap<String, Object>();
            cell.put(CELL_KEY_COLUMN, b.getJoinPath().toStringNoConstraints());
            cell.put(CELL_KEY_VIEW, CollectionUtils.collect(b.getColumns(), (Transformer)InvokerTransformer.getInstance((String)"toStringNoConstraints")));
            ArrayList rows = new ArrayList();
            cell.put(CELL_KEY_ROWS, rows);
            for (List<Either<ResultCell, SubTable>> items : b.getRows()) {
                ArrayList<Map<String, Object>> row = new ArrayList<Map<String, Object>>();
                rows.add(row);
                for (Either<ResultCell, SubTable> item : items) {
                    row.add(item.accept(this));
                }
            }
            return cell;
        }
    }
}

