/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.query.result;

import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.log4j.Logger;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.query.result.XMLValidatorErrorHandler;
import org.xml.sax.SAXParseException;

public class XMLValidator {
    private static final String QUERY_XMLNS = "<xsq:query xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsq=\"http://intermine.org/query/1.0\" xsi:schemaLocation=\"http://intermine.org/query/1.0 query.xsd\"";
    private XMLValidatorErrorHandler errorHandler = null;
    private static final Logger LOG = Logger.getLogger(XMLValidator.class);

    public void validate(String xmlToValidate, String xmlSchemaUrl) {
        String xml = xmlToValidate;
        this.errorHandler = new XMLValidatorErrorHandler();
        try {
            String[] parts = xmlSchemaUrl.split(Pattern.quote("/"));
            if ("query.xsd".equals(parts[parts.length - 1])) {
                xml = xml.replaceAll(Pattern.quote("<query"), QUERY_XMLNS);
                xml = xml.replaceAll(Pattern.quote("</query>"), "</xsq:query>");
            }
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL schemaLocation = new URL(xmlSchemaUrl);
            InputStreamReader schemaReader = new InputStreamReader(schemaLocation.openStream());
            Schema schema = factory.newSchema(new StreamSource(schemaReader));
            Validator validator = schema.newValidator();
            validator.setErrorHandler(this.errorHandler);
            validator.validate(new StreamSource(new StringReader(xml)));
        }
        catch (SAXParseException e) {
            LOG.debug((Object)e);
        }
        catch (Exception e) {
            throw new ServiceException("XML validation failed. " + xmlSchemaUrl, e);
        }
    }

    public List<String> getErrors() {
        return this.errorHandler.getErrors();
    }

    public List<String> getWarnings() {
        return this.errorHandler.getWarnings();
    }

    public List<String> getErrorsAndWarnings() {
        ArrayList<String> ret = new ArrayList<String>(this.getErrors());
        ret.addAll(this.getWarnings());
        return ret;
    }
}

