/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.search;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.response.FacetField;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagManager;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.searchengine.KeywordSearchFacet;
import org.intermine.api.searchengine.KeywordSearchFacetData;
import org.intermine.api.searchengine.KeywordSearchPropertiesManager;
import org.intermine.api.searchengine.KeywordSearchResults;
import org.intermine.api.searchengine.solr.SolrKeywordSearchHandler;
import org.intermine.objectstore.ObjectStore;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.logic.RequestUtil;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.web.search.KeywordSearchResult;
import org.intermine.web.search.SearchUtils;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.output.Output;
import org.intermine.webservice.server.output.StreamedOutput;
import org.intermine.webservice.server.output.XMLFormatter;
import org.intermine.webservice.server.search.QuickSearchJSONProcessor;
import org.intermine.webservice.server.search.QuickSearchResultProcessor;
import org.intermine.webservice.server.search.QuickSearchTextProcessor;
import org.intermine.webservice.server.search.QuickSearchXMLProcessor;

public class QuickSearch
extends JSONService {
    private static final String FACET_PREFIX = "facet_";
    private static final int PREFIX_LEN = "facet_".length();
    private static final Logger LOG = Logger.getLogger(QuickSearch.class);
    private Map<String, Map<String, Object>> headerObjs = new HashMap<String, Map<String, Object>>();
    Map<String, String> kvPairs = new HashMap<String, String>();
    private final ServletContext servletContext;

    public QuickSearch(InterMineAPI im, ServletContext ctx) {
        super(im);
        this.servletContext = ctx;
    }

    @Override
    protected void execute() throws Exception {
        String contextPath = this.servletContext.getRealPath("/");
        KeywordSearchPropertiesManager keywordSearchPropertiesManager = KeywordSearchPropertiesManager.getInstance((ObjectStore)this.im.getObjectStore());
        WebConfig wc = InterMineContext.getWebConfig();
        QuickSearchRequest input = new QuickSearchRequest();
        Vector facets = keywordSearchPropertiesManager.getFacets();
        Map<String, String> facetValues = this.getFacetValues(facets);
        SolrKeywordSearchHandler keywordSearchHandler = new SolrKeywordSearchHandler();
        KeywordSearchResults results = keywordSearchHandler.doKeywordSearch(this.im, input.searchTerm, facetValues, input.getListIds(), input.offset);
        Collection<KeywordSearchResult> searchResultsParsed = SearchUtils.parseResults(this.im, wc, results.getHits());
        if (input.getIncludeFacets()) {
            HashMap facetData = new HashMap();
            for (KeywordSearchFacet kwsf : results.getFacets()) {
                HashMap<String, Integer> sfData = new HashMap<String, Integer>();
                List items = kwsf.getItems();
                for (FacetField.Count key : items) {
                    sfData.put(key.getName(), (int)key.getCount());
                }
                facetData.put(kwsf.getField(), sfData);
            }
            this.headerObjs.put("facets", facetData);
        }
        this.kvPairs.put("totalHits", String.valueOf(results.getTotalHits()));
        QuickSearchResultProcessor processor = this.getProcessor();
        Iterator<KeywordSearchResult> it = searchResultsParsed.iterator();
        int i = 0;
        while (input.wantsMore(i) && it.hasNext()) {
            KeywordSearchResult kwsr = it.next();
            this.output.addResultItem(processor.formatResult(kwsr, input.wantsMore(i + 1) && it.hasNext()));
            ++i;
        }
    }

    @Override
    protected Map<String, Object> getHeaderAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.putAll(super.getHeaderAttributes());
        if (this.formatIsJSON()) {
            attributes.put("key_value_pairs", this.kvPairs);
            attributes.put("intro", "\"results\":[");
            attributes.put("outro", "]");
            attributes.put("headerObjs", this.headerObjs);
        }
        return attributes;
    }

    private Map<String, String> getFacetValues(Vector<KeywordSearchFacetData> facets) {
        HashMap<String, String> facetValues = new HashMap<String, String>();
        Enumeration params = this.request.getParameterNames();
        block0: while (params.hasMoreElements()) {
            String facetField;
            String param = (String)params.nextElement();
            String value = this.request.getParameter(param);
            if (!param.startsWith(FACET_PREFIX) || StringUtils.isBlank((String)value) || StringUtils.isBlank((String)(facetField = param.substring(PREFIX_LEN)))) continue;
            for (KeywordSearchFacetData facet : facets) {
                if (!facetField.equals(facet.getField())) continue;
                facetValues.put(facetField, value);
                continue block0;
            }
        }
        return facetValues;
    }

    private QuickSearchResultProcessor getProcessor() {
        if (this.formatIsJSON()) {
            return new QuickSearchJSONProcessor();
        }
        if (this.formatIsXML()) {
            return new QuickSearchXMLProcessor();
        }
        String separator = RequestUtil.isWindowsClient(this.request) ? "\r\n" : "\n";
        return new QuickSearchTextProcessor(separator);
    }

    @Override
    protected Output makeXMLOutput(PrintWriter out, String separator) {
        ResponseUtil.setXMLHeader(this.response, "search.xml");
        return new StreamedOutput(out, new QuickSearchXMLFormatter());
    }

    private class QuickSearchXMLFormatter
    extends XMLFormatter {
        private QuickSearchXMLFormatter() {
        }

        @Override
        public String formatResult(List<String> resultRow) {
            return StringUtils.join(resultRow, (String)"");
        }
    }

    private class QuickSearchRequest {
        private final String searchTerm;
        private final int offset;
        private final Integer limit;
        private final String searchBag;
        private final boolean includeFacets;

        QuickSearchRequest() {
            String query = QuickSearch.this.request.getParameter("q");
            this.searchTerm = StringUtils.isBlank((String)query) ? "*:*" : query;
            LOG.debug((Object)String.format("SEARCH TERM: '%s'", this.searchTerm));
            this.includeFacets = Boolean.valueOf(QuickSearch.this.request.getParameter("nofacets")) == false;
            String limitParam = QuickSearch.this.request.getParameter("size");
            Integer lim = null;
            if (!StringUtils.isBlank((String)limitParam)) {
                try {
                    lim = Integer.valueOf(limitParam);
                }
                catch (NumberFormatException e) {
                    throw new BadRequestException("Expected a number for size: got " + limitParam);
                }
            }
            this.limit = lim;
            String offsetP = QuickSearch.this.request.getParameter("start");
            int parsed = 0;
            if (!StringUtils.isBlank((String)offsetP)) {
                try {
                    parsed = Integer.valueOf(offsetP);
                }
                catch (NumberFormatException e) {
                    throw new BadRequestException("Expected a number for start: got " + offsetP);
                }
            }
            this.offset = parsed;
            this.searchBag = QuickSearch.this.request.getParameter("list");
        }

        public boolean wantsMore(int i) {
            if (this.limit == null) {
                return true;
            }
            return i < this.limit;
        }

        public boolean getIncludeFacets() {
            return this.includeFacets;
        }

        public String toString() {
            return String.format("<%s searchTerm=%s offset=%d>", this.getClass().getName(), this.searchTerm, this.offset);
        }

        public List<Integer> getListIds() {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            if (!StringUtils.isBlank((String)this.searchBag)) {
                LOG.debug((Object)("SEARCH BAG: '" + this.searchBag + "'"));
                BagManager bm = QuickSearch.this.im.getBagManager();
                Profile p = QuickSearch.this.getPermission().getProfile();
                InterMineBag bag = bm.getBag(p, this.searchBag);
                if (bag == null) {
                    throw new BadRequestException("You do not have access to a bag named '" + this.searchBag + "'");
                }
                ids.addAll(bag.getContentsAsIds());
            }
            return ids;
        }
    }
}

