/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.intermine.web.search.KeywordSearchResult;
import org.intermine.webservice.server.search.QuickSearchResultProcessor;

public class QuickSearchXMLProcessor
implements QuickSearchResultProcessor {
    private static final String TAG_NAME = "result";
    private static final String FIELD_TAG = "field";

    @Override
    public List<String> formatResult(KeywordSearchResult result, boolean hasNext) {
        HashMap<String, Object> data = new HashMap<String, Object>(result.getFieldValues());
        ArrayList<String> ret = new ArrayList<String>();
        StringBuffer sb = new StringBuffer(String.format("<%s type=\"%s\" id=\"%d\" score=\"%f\">", TAG_NAME, result.getType(), result.getId(), Float.valueOf(result.getScore())));
        for (Map.Entry kv : data.entrySet()) {
            sb.append(String.format("<%s name=\"%s\">", FIELD_TAG, StringEscapeUtils.escapeXml((String)((String)kv.getKey()))));
            sb.append(StringEscapeUtils.escapeXml((String)(kv.getValue() + "")));
            sb.append(String.format("</%s>", FIELD_TAG));
        }
        sb.append(String.format("</%s>", TAG_NAME));
        ret.add(sb.toString());
        return ret;
    }
}

