/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.template;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.template.TemplateHelper;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.WebService;
import org.intermine.webservice.server.exceptions.NotAcceptableException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.exceptions.UnauthorizedException;
import org.intermine.webservice.server.output.Output;
import org.intermine.webservice.server.output.PlainFormatter;
import org.intermine.webservice.server.output.StreamedOutput;

public class AllAvailableTemplatesService
extends WebService {
    private static final String FILE_BASE_NAME = "templates";

    public AllAvailableTemplatesService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected Output makeXMLOutput(PrintWriter out, String separator) {
        ResponseUtil.setXMLHeader(this.response, "templates.xml");
        return new StreamedOutput(out, new PlainFormatter(), separator);
    }

    @Override
    protected Format getDefaultFormat() {
        return Format.XML;
    }

    @Override
    protected boolean canServe(Format format) {
        return Format.BASIC_FORMATS.contains((Object)format);
    }

    @Override
    protected void execute() throws Exception {
        if (this.isAuthenticated()) {
            Profile authenticatedProfile = this.getPermission().getProfile();
            if (!authenticatedProfile.isSuperuser()) {
                throw new UnauthorizedException("The request must be authenticated by a super user");
            }
            switch (this.getFormat()) {
                case XML: {
                    this.output.addResultItem(Arrays.asList(TemplateHelper.allTemplatesMapToXml((InterMineAPI)this.im)));
                    break;
                }
                case JSON: {
                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                    attributes.put("intro", "\"templates\":");
                    this.output.setHeaderAttributes(attributes);
                    this.output.addResultItem(Arrays.asList(TemplateHelper.allTemplatesMapToJson((InterMineAPI)this.im)));
                    break;
                }
                case TEXT: {
                    throw new ServiceException("Not implemented: " + (Object)((Object)Format.TEXT));
                }
                case HTML: {
                    throw new ServiceException("Not implemented: " + (Object)((Object)Format.HTML));
                }
                default: {
                    throw new NotAcceptableException();
                }
            }
        } else {
            throw new UnauthorizedException("The request must be authenticated by a super user");
        }
    }
}

