/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.template;

import java.io.PrintWriter;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.template.ApiTemplate;
import org.intermine.api.template.TemplateManager;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;
import org.intermine.webservice.server.output.Output;
import org.intermine.webservice.server.output.PlainFormatter;
import org.intermine.webservice.server.output.StreamedOutput;

public class SingleTemplateService
extends JSONService {
    public SingleTemplateService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected boolean canServe(Format format) {
        switch (format) {
            case XML: 
            case JSON: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Output makeXMLOutput(PrintWriter out, String separator) {
        ResponseUtil.setXMLHeader(this.response, "template.xml");
        return new StreamedOutput(out, new PlainFormatter(), separator);
    }

    @Override
    protected void execute() {
        String name = StringUtils.defaultString((String)this.request.getPathInfo(), (String)"");
        if (StringUtils.isBlank((String)(name = name.replaceAll("^/", "")))) {
            throw new BadRequestException("No name provided");
        }
        Profile p = this.getPermission().getProfile();
        TemplateManager tm = this.im.getTemplateManager();
        ApiTemplate t = tm.getUserOrGlobalTemplate(p, name);
        if (t == null) {
            throw new ResourceNotFoundException("No template found called " + name);
        }
        if (Format.JSON == this.getFormat()) {
            this.output.addResultItem(Arrays.asList(t.toJSON()));
        } else {
            ResponseUtil.setXMLHeader(this.response, name + ".xml");
            this.output.addResultItem(Arrays.asList(t.toXml()));
        }
    }

    @Override
    public String getResultsKey() {
        return "template";
    }
}

