/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.template;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.intermine.api.InterMineAPI;
import org.intermine.api.template.TemplateHelper;
import org.intermine.api.template.TemplateManager;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.WebService;
import org.intermine.webservice.server.exceptions.NotAcceptableException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.output.Output;
import org.intermine.webservice.server.output.PlainFormatter;
import org.intermine.webservice.server.output.StreamedOutput;

public class SystemTemplatesService
extends WebService {
    private static final String FILE_BASE_NAME = "templates";

    public SystemTemplatesService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected Output makeXMLOutput(PrintWriter out, String separator) {
        ResponseUtil.setXMLHeader(this.response, "templates.xml");
        return new StreamedOutput(out, new PlainFormatter(), separator);
    }

    @Override
    protected Format getDefaultFormat() {
        return Format.XML;
    }

    @Override
    protected boolean canServe(Format format) {
        return Format.BASIC_FORMATS.contains((Object)format);
    }

    @Override
    protected void execute() throws Exception {
        TemplateManager templateManager = this.im.getTemplateManager();
        Map templates = templateManager.getSystemTemplates();
        switch (this.getFormat()) {
            case XML: {
                this.output.addResultItem(Arrays.asList(TemplateHelper.apiTemplateMapToXml((Map)templates, (int)2)));
                break;
            }
            case JSON: {
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                if (this.formatIsJSONP()) {
                    attributes.put("callback", this.getCallback());
                }
                attributes.put("intro", "\"templates\":");
                this.output.setHeaderAttributes(attributes);
                this.output.addResultItem(Arrays.asList(TemplateHelper.apiTemplateMapToJson((InterMineAPI)this.im, (Map)templates, null)));
                break;
            }
            case TEXT: {
                TreeSet templateNames = new TreeSet(templates.keySet());
                for (String templateName : templateNames) {
                    this.output.addResultItem(Arrays.asList(templateName));
                }
            }
            case HTML: {
                throw new ServiceException("Not implemented: " + (Object)((Object)Format.HTML));
            }
            default: {
                throw new NotAcceptableException();
            }
        }
    }
}

