/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.template.ApiTemplate;
import org.intermine.api.template.TemplatePrecomputeHelper;
import org.intermine.objectstore.intermine.ObjectStoreInterMineImpl;
import org.intermine.objectstore.query.Query;
import org.intermine.template.TemplateQuery;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;

public class TemplatePrecomputeStatusService
extends JSONService {
    public TemplatePrecomputeStatusService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected void validateState() {
        if (!this.isAuthenticated() || !this.getPermission().getProfile().isSuperuser()) {
            throw new ServiceForbiddenException("This request is not authenticated.");
        }
    }

    @Override
    protected boolean canServe(Format format) {
        switch (format) {
            case TEXT: 
            case JSON: 
            case HTML: 
            case XML: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void execute() throws Exception {
        Profile currentProfile = this.getPermission().getProfile();
        Map templates = currentProfile.getSavedTemplates();
        ObjectStoreInterMineImpl os = (ObjectStoreInterMineImpl)this.im.getObjectStore();
        HashMap<String, Boolean> precomputedTemplateMap = new HashMap<String, Boolean>();
        String templateName = this.getOptionalParameter("name");
        if (!StringUtils.isEmpty((String)templateName)) {
            TemplateQuery template = (TemplateQuery)templates.get(templateName);
            if (template == null) {
                throw new BadRequestException("The template " + templateName + " doesn't exist");
            }
            if (template.isValid()) {
                Query query = TemplatePrecomputeHelper.getPrecomputeQuery((TemplateQuery)template, new ArrayList(), null);
                precomputedTemplateMap.put(template.getName(), os.isPrecomputed(query, "template"));
            }
        } else {
            for (ApiTemplate template : templates.values()) {
                if (!template.isValid()) continue;
                Query query = TemplatePrecomputeHelper.getPrecomputeQuery((TemplateQuery)template, new ArrayList(), null);
                precomputedTemplateMap.put(template.getName(), os.isPrecomputed(query, "template"));
            }
        }
        this.addResultItem(precomputedTemplateMap, false);
    }

    @Override
    public String getResultsKey() {
        return "templates";
    }
}

