/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.template;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.template.ApiTemplate;
import org.intermine.api.template.TemplateSummariser;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;

public class TemplateSummariseService
extends JSONService {
    private static final Logger LOG = Logger.getLogger(TemplateSummariseService.class);

    public TemplateSummariseService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected void validateState() {
        if (!this.isAuthenticated() || !this.getPermission().getProfile().isSuperuser()) {
            throw new ServiceForbiddenException("This request is not authenticated.");
        }
    }

    @Override
    protected boolean canServe(Format format) {
        switch (format) {
            case TEXT: 
            case JSON: 
            case HTML: 
            case XML: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void execute() throws Exception {
        String templateName = this.getRequiredParameter("name");
        Profile currentProfile = this.getPermission().getProfile();
        Map templates = currentProfile.getSavedTemplates();
        ApiTemplate template = (ApiTemplate)templates.get(templateName);
        HashMap<String, Boolean> summarisedTemplateMap = new HashMap<String, Boolean>();
        if (template == null) {
            throw new BadRequestException("The template " + templateName + " doesn't exist");
        }
        if (!template.isValid()) {
            throw new BadRequestException("The template " + templateName + " is not valid");
        }
        TemplateSummariser summariser = this.im.getTemplateSummariser();
        try {
            summariser.summarise(template);
            summarisedTemplateMap.put(templateName, true);
        }
        catch (ObjectStoreException e) {
            LOG.error((Object)"Error while summarising", (Throwable)e);
            summarisedTemplateMap.put(templateName, false);
        }
        this.addResultItem(summarisedTemplateMap, false);
    }

    @Override
    public String getResultsKey() {
        return "templates";
    }
}

