/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.template;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.template.ApiTemplate;
import org.intermine.api.template.TemplateSummariser;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;

public class TemplateSummariseStatusService
extends JSONService {
    public TemplateSummariseStatusService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected void validateState() {
        if (!this.isAuthenticated() || !this.getPermission().getProfile().isSuperuser()) {
            throw new ServiceForbiddenException("This request is not authenticated.");
        }
    }

    @Override
    protected boolean canServe(Format format) {
        switch (format) {
            case TEXT: 
            case JSON: 
            case HTML: 
            case XML: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void execute() throws Exception {
        String templateName = this.getOptionalParameter("name");
        Profile currentProfile = this.getPermission().getProfile();
        Map templates = currentProfile.getSavedTemplates();
        TemplateSummariser summariser = this.im.getTemplateSummariser();
        HashMap<String, Boolean> summarisedTemplateMap = new HashMap<String, Boolean>();
        if (!StringUtils.isEmpty((String)templateName)) {
            ApiTemplate template = (ApiTemplate)templates.get(templateName);
            if (template == null) {
                throw new BadRequestException("The template " + templateName + " doesn't exist");
            }
            if (template.isValid()) {
                summarisedTemplateMap.put(template.getName(), summariser.isSummarised(template));
            }
        } else {
            for (ApiTemplate template : templates.values()) {
                if (!template.isValid()) continue;
                summarisedTemplateMap.put(template.getName(), summariser.isSummarised(template));
            }
        }
        this.addResultItem(summarisedTemplateMap, false);
    }

    @Override
    public String getResultsKey() {
        return "templates";
    }
}

