/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.TransformerUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.Taggable;
import org.intermine.api.template.ApiTemplate;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;

public class TemplateTagService
extends JSONService {
    public TemplateTagService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected Map<String, Object> getHeaderAttributes() {
        Map<String, Object> attributes = super.getHeaderAttributes();
        attributes.put("intro", "\"tags\":[");
        attributes.put("outro", "]");
        attributes.put("should_quote", true);
        return attributes;
    }

    @Override
    protected void execute() throws Exception {
        Profile profile = this.getPermission().getProfile();
        String templateName = this.getOptionalParameter("name", null);
        Set<Object> tags = new HashSet();
        if (!"__ANONYMOUS_USER__".equals(profile.getUsername())) {
            tags = templateName == null ? this.getAllTags(profile) : this.getTagsForSingleTemplate(templateName, profile);
        }
        this.output.addResultItem(new ArrayList<String>(tags));
    }

    private Set<String> getTagsForSingleTemplate(String name, Profile profile) {
        Map templates = this.im.getTemplateManager().getUserAndGlobalTemplates(profile);
        ApiTemplate template = (ApiTemplate)templates.get(name);
        if (template == null) {
            throw new ResourceNotFoundException("You do not have access to a template called '" + name + "'");
        }
        List tags = this.im.getTagManager().getObjectTags((Taggable)template, profile);
        Collection tagNames = CollectionUtils.collect((Collection)tags, (Transformer)TransformerUtils.invokerTransformer((String)"getTagName"));
        return new HashSet<String>(tagNames);
    }

    private Set<String> getAllTags(Profile profile) {
        return this.im.getTagManager().getUserTagNames("template", profile);
    }
}

