/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.template;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.BadTemplateException;
import org.intermine.api.profile.Profile;
import org.intermine.api.template.ApiTemplate;
import org.intermine.metadata.Model;
import org.intermine.template.TemplateQuery;
import org.intermine.template.xml.TemplateQueryBinding;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.WebService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;

public class TemplateUploadService
extends WebService {
    public static final String TEMPLATES_PARAMETER = "query";
    public static final String VERSION_PARAMETER = "version";

    public TemplateUploadService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected void validateState() {
        if (!this.isAuthenticated()) {
            throw new ServiceForbiddenException("This request is not authenticated.");
        }
        if (!this.getPermission().isRW()) {
            throw new ServiceForbiddenException("This request does not have RW permission.");
        }
    }

    @Override
    protected boolean canServe(Format format) {
        switch (format) {
            case TEXT: 
            case JSON: 
            case HTML: 
            case XML: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void execute() throws Exception {
        Map templates;
        String templatesXML = "";
        String contentType = StringUtils.defaultString((String)this.request.getContentType(), (String)"");
        templatesXML = contentType.contains("application/x-www-form-urlencoded") || "GET".equalsIgnoreCase(this.request.getMethod()) ? this.getRequiredParameter(TEMPLATES_PARAMETER) : IOUtils.toString((InputStream)this.request.getInputStream());
        Profile profile = this.getPermission().getProfile();
        int version = this.getIntParameter(VERSION_PARAMETER, 2);
        StringReader r = new StringReader(templatesXML);
        try {
            templates = templatesXML.startsWith("<") ? TemplateQueryBinding.unmarshalTemplates((Reader)r, (int)version) : TemplateQueryBinding.unmarshalJSONTemplates((Reader)r, (Model)this.im.getModel());
        }
        catch (Exception e) {
            throw new BadRequestException("Could not parse templates: " + e.getMessage(), e);
        }
        for (TemplateQuery templateQuery : templates.values()) {
            if (templateQuery.isValid()) continue;
            String message = String.format("Template %s contains errors: %s", StringUtils.defaultIfBlank((String)templateQuery.getName(), (String)"NO-NAME"), this.formatMessage(templateQuery.verifyQuery()));
            throw new BadRequestException(message);
        }
        for (Map.Entry entry : templates.entrySet()) {
            String name = (String)entry.getKey();
            try {
                profile.saveTemplate(name, new ApiTemplate((TemplateQuery)entry.getValue()));
            }
            catch (BadTemplateException bte) {
                throw new BadRequestException("The template has an invalid name.");
            }
            catch (RuntimeException e) {
                throw new ServiceException("Failed to save template: " + name, e);
            }
        }
    }

    private String formatMessage(List<String> msgs) {
        StringBuilder sb = new StringBuilder();
        for (String msg : msgs) {
            sb.append(msg);
            if (msg.endsWith(".")) continue;
            sb.append(".");
        }
        return sb.toString();
    }
}

