/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.template.result;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.intermine.metadata.ConstraintOp;
import org.intermine.metadata.StringUtil;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathConstraintAttribute;
import org.intermine.pathquery.PathConstraintBag;
import org.intermine.pathquery.PathConstraintLookup;
import org.intermine.pathquery.PathConstraintMultiValue;
import org.intermine.pathquery.PathConstraintNull;
import org.intermine.template.SwitchOffAbility;
import org.intermine.template.TemplateQuery;
import org.intermine.webservice.server.CodeTranslator;
import org.intermine.webservice.server.LinkGeneratorBase;

public class TemplateResultLinkGenerator
extends LinkGeneratorBase {
    public static final int DEFAULT_RESULT_SIZE = 10;
    private String error;

    public String getMineResultsLink(String baseUrl, TemplateQuery tq) {
        return baseUrl + this.getMineResultsPath(tq, false);
    }

    public String getMineResultsPath(TemplateQuery tq, boolean highlighted) {
        String ret = "/loadTemplate.do?";
        ret = ret + this.getTemplateParameterQueryString(tq, highlighted);
        ret = ret + "&method=results";
        return ret;
    }

    public String getHtmlLink(String baseUrl, TemplateQuery template) {
        return this.getHtmlLinkInternal(baseUrl, template, false);
    }

    private String getHtmlLinkInternal(String baseUrl, TemplateQuery template, boolean hl) {
        String ret = this.getLink(baseUrl, template, "html", hl);
        ret = ret + "&size=";
        ret = ret + this.format("10", hl);
        ret = ret + "&layout=minelink|paging";
        return ret;
    }

    public String getTabLink(String baseUrl, TemplateQuery template) {
        String ret = this.getLink(baseUrl, template, false);
        ret = ret + "&size=10";
        return ret;
    }

    public String getLinkPath(TemplateQuery template) {
        return this.getLinkPath(template, "tab");
    }

    public String getLinkPath(TemplateQuery template, String format) {
        return this.getLinkPath(template, format, false);
    }

    private String getTemplateParameterQueryString(TemplateQuery tq, boolean highlighted) {
        String ret = "name=" + tq.getName();
        if (highlighted) {
            ret = ret + "<br />";
        }
        int index = 1;
        Map<String, List<PathConstraint>> consMap = this.getConstraints(tq);
        for (String path : consMap.keySet()) {
            List<PathConstraint> constraints = consMap.get(path);
            for (PathConstraint con : constraints) {
                if (SwitchOffAbility.OFF.equals((Object)tq.getSwitchOffAbility(con))) continue;
                ret = ret + "&" + this.pathToString(path, index);
                if (constraints.size() > 1) {
                    String code = (String)tq.getConstraints().get(con);
                    ret = ret + "&" + this.codeToString(code, index);
                }
                ret = ret + "&" + this.operationToString(con.getOp(), index, highlighted);
                if (con instanceof PathConstraintMultiValue) {
                    for (String value : ((PathConstraintMultiValue)con).getValues()) {
                        ret = ret + "&" + this.valueToString(value, index, highlighted);
                    }
                } else {
                    ret = ret + "&" + this.valueToString(this.getConstraintValue(con), index, highlighted);
                }
                if (con instanceof PathConstraintLookup) {
                    PathConstraintLookup conLookup = (PathConstraintLookup)con;
                    ret = ret + "&" + this.extraToString(conLookup.getExtraValue(), index, highlighted);
                }
                if (highlighted) {
                    ret = ret + "<br />";
                }
                ++index;
            }
        }
        return ret;
    }

    public String getLinkPath(TemplateQuery template, String format, boolean highlighted) {
        String ret = "/service/template/results?";
        ret = ret + this.getTemplateParameterQueryString(template, highlighted);
        ret = ret + "&format=" + format;
        return ret;
    }

    public String getHighlightedLink(String baseUrl, TemplateQuery template) {
        return this.getHtmlLinkInternal(baseUrl, template, true);
    }

    private String getLink(String baseUrl, TemplateQuery template, boolean hl) {
        return this.getLink(baseUrl, template, "tab", hl);
    }

    private String getLink(String baseUrl, TemplateQuery template, String format, boolean highlighted) {
        String ret = baseUrl + this.getLinkPath(template, format, highlighted);
        return ret;
    }

    private String codeToString(String code, int index) {
        return "code" + index + "=" + code;
    }

    private String pathToString(String path, int index) {
        return "constraint" + index + "=" + path;
    }

    private String operationToString(ConstraintOp op, int index, boolean highlighted) {
        String ret = "";
        ret = ret + "op" + index + "=";
        ret = ret + this.format(TemplateResultLinkGenerator.encode(CodeTranslator.getAbbreviation(op.toString())), highlighted);
        return ret;
    }

    private String valueToString(Object valueObject, int index, boolean highlighted) {
        String ret = "";
        ret = ret + "value" + index + "=";
        String value = TemplateResultLinkGenerator.encode(this.objectToString(valueObject));
        ret = ret + this.format(value, highlighted);
        return ret;
    }

    private String objectToString(Object o) {
        if (o != null) {
            return o.toString();
        }
        return "";
    }

    private String extraToString(Object extraValue, int index, boolean highlighted) {
        String ret = "";
        ret = ret + "extra" + index + "=";
        ret = ret + this.format(TemplateResultLinkGenerator.encode(this.objectToString(extraValue)), highlighted);
        return ret;
    }

    private Map<String, List<PathConstraint>> getConstraints(TemplateQuery template) {
        HashMap<String, List<PathConstraint>> ret = new HashMap<String, List<PathConstraint>>();
        for (String editablePath : template.getEditablePaths()) {
            ret.put(editablePath, template.getEditableConstraints(editablePath));
        }
        return ret;
    }

    private String format(String text, boolean highlight) {
        if (highlight) {
            return "<span class=\"highlighted\">" + text + "</span>";
        }
        return text;
    }

    public String getError() {
        return this.error;
    }

    private String getConstraintValue(PathConstraint con) {
        if (con instanceof PathConstraintAttribute) {
            return ((PathConstraintAttribute)con).getValue();
        }
        if (con instanceof PathConstraintLookup) {
            return ((PathConstraintLookup)con).getValue();
        }
        if (con instanceof PathConstraintBag) {
            return ((PathConstraintBag)con).getBag();
        }
        if (con instanceof PathConstraintMultiValue) {
            return StringUtil.join((Collection)((PathConstraintMultiValue)con).getValues(), (String)",");
        }
        if (con instanceof PathConstraintNull) {
            return ((PathConstraintNull)con).getOp().toString();
        }
        throw new IllegalArgumentException("Constraints of type '" + con.getClass() + "' are not yet supported template queries.");
    }
}

