/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.template.result;

import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.template.ApiTemplate;
import org.intermine.api.template.TemplateManager;
import org.intermine.api.template.TemplatePopulator;
import org.intermine.pathquery.PathQuery;
import org.intermine.template.TemplatePopulatorException;
import org.intermine.template.TemplateQuery;
import org.intermine.template.TemplateValue;
import org.intermine.web.logic.template.TemplateResultInput;
import org.intermine.web.logic.template.Templates;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;
import org.intermine.webservice.server.query.result.PathQueryBuilderForJSONObj;
import org.intermine.webservice.server.query.result.QueryResultService;
import org.intermine.webservice.server.template.result.TemplateResultRequestParser;

public class TemplateResultService
extends QueryResultService {
    public static final String TYPE_PARAMETER = "type";
    public static final String NAME_PARAMETER = "name";
    private static final Logger LOG = Logger.getLogger(TemplateResultService.class);

    public TemplateResultService(InterMineAPI im) {
        super(im);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void execute() {
        TemplateQuery populatedTemplate;
        Map<String, List<TemplateValue>> templateValues;
        TemplateManager templateManager = this.im.getTemplateManager();
        TemplateResultInput input = this.getInput();
        ApiTemplate template = null;
        Profile profile = this.getPermission().getProfile();
        if (profile.isSuperuser() && input.getUserName() != null) {
            Profile inputProfile = this.im.getProfileManager().getProfile(input.getUserName());
            if (inputProfile == null) throw new ResourceNotFoundException("The user " + input.getUserName() + " doesn't exist");
            template = templateManager.getUserOrGlobalTemplate(inputProfile, input.getName());
        } else {
            template = templateManager.getUserOrGlobalTemplate(profile, input.getName());
        }
        if (template == null) {
            throw new ResourceNotFoundException("You do not have access to a template called '" + input.getName() + "' in this mine.");
        }
        try {
            templateValues = Templates.getValuesFromInput((TemplateQuery)template, input);
        }
        catch (Templates.TemplateValueParseException e) {
            throw new BadRequestException(e.getMessage(), e);
        }
        try {
            populatedTemplate = TemplatePopulator.getPopulatedTemplate((TemplateQuery)template, templateValues);
        }
        catch (TemplatePopulatorException e) {
            e.printStackTrace();
            LOG.error((Object)("Error populating template: " + template.getName() + ". " + (Object)((Object)e)));
            throw new BadRequestException("Error in applying constraint values to template: " + template.getName(), e);
        }
        if (this.formatIsJsonObj()) {
            List<String> newView = PathQueryBuilderForJSONObj.getAlteredViews((PathQuery)populatedTemplate);
            populatedTemplate.clearView();
            populatedTemplate.addViews(newView);
        }
        this.setHeaderAttributes((PathQuery)populatedTemplate, input.getStart(), input.getLimit());
        if (!populatedTemplate.isValid()) {
            String msg = "Required data source (template) is outdated and is in conflict with model: " + populatedTemplate.verifyQuery();
            throw new BadRequestException(msg);
        }
        this.runPathQuery((PathQuery)populatedTemplate, input.getStart(), input.getLimit());
    }

    private TemplateResultInput getInput() {
        return new TemplateResultRequestParser(this.request).getInput();
    }
}

