/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.user;

import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileManager;
import org.intermine.api.userprofile.PermanentToken;
import org.intermine.api.userprofile.UserProfile;
import org.intermine.webservice.server.core.ReadWriteJSONService;
import org.intermine.webservice.server.exceptions.ServiceException;

public class DeleteTokensService
extends ReadWriteJSONService {
    public DeleteTokensService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected void execute() throws Exception {
        Profile profile = this.getPermission().getProfile();
        if (profile.getUserId() == null) {
            return;
        }
        ProfileManager pm = this.im.getProfileManager();
        UserProfile up = (UserProfile)pm.getProfileObjectStoreWriter().getObjectById(profile.getUserId());
        if (up == null) {
            throw new ServiceException("Could not load user profile");
        }
        for (PermanentToken t : up.getPermanentTokens()) {
            pm.removePermanentToken(t);
        }
    }
}

