/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.user;

import java.util.UUID;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;
import org.intermine.webservice.server.user.DeletionToken;
import org.intermine.webservice.server.user.DeletionTokens;
import org.intermine.webservice.server.user.NewDeletionTokenService;

public class DeletionTokenInfoService
extends NewDeletionTokenService {
    private String uuid;

    public DeletionTokenInfoService(InterMineAPI im, String uid) {
        super(im);
        this.uuid = uid;
    }

    @Override
    protected void execute() {
        DeletionToken token = this.getToken();
        this.serveToken(token);
    }

    protected DeletionToken getToken() {
        DeletionToken token;
        Profile profile = this.getPermission().getProfile();
        try {
            UUID key = UUID.fromString(this.uuid);
            token = this.tokenFactory.retrieveToken(key);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.uuid + " is not a deletion token.");
        }
        catch (DeletionTokens.TokenExpired e) {
            throw new BadRequestException("token expired.");
        }
        if (!profile.equals(token.getProfile())) {
            throw new ServiceForbiddenException("Access denied");
        }
        return token;
    }
}

