/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.user;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.intermine.api.profile.Profile;
import org.intermine.webservice.server.user.DeletionToken;

public final class DeletionTokens {
    private static final int MINIMUM_LIFE = 10;
    private static final int MAXIMUM_LIFE = 86400;
    private Map<UUID, DeletionToken> tokens = new HashMap<UUID, DeletionToken>();
    private static DeletionTokens instance = new DeletionTokens();

    public static DeletionTokens getInstance() {
        return instance;
    }

    private DeletionTokens() {
    }

    public DeletionToken createToken(Profile profile, int lifeSpan) {
        if (lifeSpan < 10) {
            throw new IllegalArgumentException("Life too short: " + lifeSpan);
        }
        if (lifeSpan > 86400) {
            throw new IllegalArgumentException("Life too long: " + lifeSpan);
        }
        UUID uuid = UUID.randomUUID();
        Date expiry = new Date(System.currentTimeMillis() + (long)(lifeSpan * 1000));
        DeletionToken token = new DeletionToken(profile, uuid, expiry);
        this.tokens.put(uuid, token);
        return token;
    }

    public DeletionToken retrieveToken(UUID key) throws TokenExpired {
        if (!this.tokens.containsKey(key)) {
            throw new IllegalArgumentException("No token for " + key);
        }
        Date now = new Date();
        DeletionToken token = this.tokens.get(key);
        if (now.after(token.getExpiry())) {
            this.tokens.remove(key);
            throw new TokenExpired();
        }
        return token;
    }

    public void removeToken(DeletionToken token) {
        this.tokens.remove(token.getUUID());
    }

    static class TokenExpired
    extends Exception {
        private static final long serialVersionUID = 8392634678344992277L;

        TokenExpired() {
        }
    }
}

