/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.user;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.xml.ProfileBinding;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.util.Emailer;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.context.MailAction;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.WebService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;
import org.intermine.webservice.server.output.Output;
import org.intermine.webservice.server.output.StreamedOutput;
import org.intermine.webservice.server.user.DeletionToken;
import org.intermine.webservice.server.user.DeletionTokens;
import org.intermine.webservice.server.user.UserDataFormatter;

public class DeregistrationService
extends WebService {
    private DeletionTokens tokens = DeletionTokens.getInstance();

    public DeregistrationService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected void validateState() {
        if (!this.isAuthenticated() || this.getPermission().isRO()) {
            throw new ServiceForbiddenException("Access denied");
        }
    }

    @Override
    protected Format getDefaultFormat() {
        return Format.XML;
    }

    @Override
    protected Output makeXMLOutput(PrintWriter out, String separator) {
        ResponseUtil.setXMLHeader(this.response, "data.xml");
        return new StreamedOutput(out, new UserDataFormatter(), separator);
    }

    @Override
    protected void execute() {
        XMLStreamWriter writer;
        DeletionToken token;
        String uuid = this.getRequiredParameter("deregistrationToken");
        Profile profile = this.getPermission().getProfile();
        try {
            UUID key = UUID.fromString(uuid);
            token = this.tokens.retrieveToken(key);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(uuid + " is not a deletion token.");
        }
        catch (DeletionTokens.TokenExpired e) {
            throw new BadRequestException("token expired.");
        }
        if (!profile.equals(token.getProfile())) {
            throw new ServiceForbiddenException("Access denied");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try {
            writer = factory.createXMLStreamWriter(os);
        }
        catch (XMLStreamException e) {
            throw new ServiceException("Could not export personal data", e);
        }
        try {
            ProfileBinding.marshal((Profile)profile, (ObjectStore)this.im.getUserProfile(), (XMLStreamWriter)writer, (int)2, (Map)this.im.getClassKeys());
        }
        catch (Exception e) {
            throw new ServiceException("Error exporting userprofile", e);
        }
        String userData = os.toString();
        GoodbyeAction action = new GoodbyeAction(profile.getUsername(), userData);
        if (!InterMineContext.queueMessage(action)) {
            throw new ServiceException("Cannot send your archive at this time, try again later.", 503);
        }
        try {
            this.im.getProfileManager().deleteProfile(profile);
        }
        catch (ObjectStoreException e) {
            throw new ServiceException("Could not delete your profile.", e);
        }
        this.output.addResultItem(Arrays.asList(userData));
    }

    private class GoodbyeAction
    implements MailAction {
        private final String to;
        private final String xml;

        GoodbyeAction(String to, String xml) {
            this.to = to;
            this.xml = xml;
        }

        @Override
        public void act(Emailer emailer) throws Exception {
            emailer.sendFareWell(this.to, this.xml);
        }
    }
}

