/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.user;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.directwebremoting.util.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileManager;
import org.intermine.api.util.NameUtil;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.util.Emailer;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.context.MailAction;
import org.intermine.web.logic.profile.ProfileMergeIssues;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.core.RateLimitHistory;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.RateLimitException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.json.JSONObject;

public class NewUserService
extends JSONService {
    private static final String DEFAULTING_TO_1000PH = "Configured new user rate limit is not a valid integer. Defaulting to 1000 per hour";
    private static final Logger LOG = Logger.getLogger(NewUserService.class);
    private int maxNewUsersPerAddressPerHour = 1000;
    private static RateLimitHistory requestHistory = null;

    public NewUserService(InterMineAPI im) {
        super(im);
        if (requestHistory == null) {
            Properties webProperties = InterMineContext.getWebProperties();
            String rateLimit = webProperties.getProperty("webservice.newuser.ratelimit");
            if (rateLimit != null) {
                try {
                    this.maxNewUsersPerAddressPerHour = Integer.valueOf(rateLimit.trim());
                }
                catch (NumberFormatException e) {
                    LOG.error(DEFAULTING_TO_1000PH, (Throwable)e);
                    this.maxNewUsersPerAddressPerHour = 1000;
                }
            }
            requestHistory = new RateLimitHistory(3600, this.maxNewUsersPerAddressPerHour);
        }
    }

    @Override
    protected void validateState() {
        super.validateState();
        String ipAddr = this.request.getRemoteAddr();
        if (!requestHistory.isWithinLimit(ipAddr)) {
            throw new RateLimitException(ipAddr, this.maxNewUsersPerAddressPerHour);
        }
        requestHistory.recordRequest(ipAddr);
    }

    @Override
    protected void execute() throws Exception {
        NewUserInput input = new NewUserInput();
        Profile currentProfile = this.getPermission().getProfile();
        ProfileManager pm = this.im.getProfileManager();
        pm.createNewProfile(input.getUsername(), input.getPassword());
        Profile newProfile = pm.getProfile(input.getUsername());
        if (newProfile == null) {
            throw new ServiceException("Creating a new profile failed");
        }
        ProfileMergeIssues issues = null;
        if (currentProfile != null) {
            issues = this.attachAnonSavedBags(currentProfile, newProfile);
        }
        JSONObject user = new JSONObject();
        user.put("username", (Object)input.getUsername());
        user.put("renamedLists", (Object)new JSONObject(issues.getRenamedBags()));
        WelcomeAction welcomeMessage = new WelcomeAction(input.getUsername());
        if (!InterMineContext.queueMessage(welcomeMessage)) {
            LOG.error("Mail queue capacity exceeded. Not sending welcome message");
        }
        String mailingList = null;
        if (input.subscribeToList()) {
            mailingList = this.getProperty("mail.mailing-list");
            SubscribeAction subscribe = new SubscribeAction(input.getUsername());
            if (!InterMineContext.queueMessage(subscribe)) {
                LOG.error("Mail queue capacity exceeded. Not sending subscription message");
            }
        }
        user.put("subscribedToList", mailingList != null);
        user.put("mailingList", (Object)mailingList);
        user.put("temporaryToken", (Object)pm.generate24hrKey(newProfile));
        this.output.addResultItem(Arrays.asList(user.toString()));
    }

    @Override
    protected Map<String, Object> getHeaderAttributes() {
        Map<String, Object> retval = super.getHeaderAttributes();
        retval.put("intro", "\"user\":");
        return retval;
    }

    private ProfileMergeIssues attachAnonSavedBags(Profile fromProfile, Profile newProfile) {
        Map mergeBags = Collections.emptyMap();
        ProfileMergeIssues issues = new ProfileMergeIssues();
        if (fromProfile != null) {
            mergeBags = fromProfile.getSavedBags();
        }
        for (Map.Entry entry : mergeBags.entrySet()) {
            InterMineBag bag = (InterMineBag)entry.getValue();
            try {
                bag.setProfileId(newProfile.getUserId());
                String name = NameUtil.validateName(newProfile.getSavedBags().keySet(), (String)((String)entry.getKey()));
                if (!((String)entry.getKey()).equals(name)) {
                    issues.addRenamedBag((String)entry.getKey(), name);
                }
                bag.setName(name);
                newProfile.saveBag(name, bag);
            }
            catch (ObjectStoreException iex) {
                throw new RuntimeException(iex.getMessage());
            }
        }
        return issues;
    }

    private class NewUserInput {
        private static final String BAD_REQ_MSG = "missing parameters. name and password required";
        private static final String USER_EXISTS_MSG = "There is already a user with that name";
        private final String username;
        private final String password;
        private final boolean wantsSpam;

        NewUserInput() {
            this.username = NewUserService.this.request.getParameter("name").toLowerCase();
            this.password = NewUserService.this.request.getParameter("password");
            this.wantsSpam = Boolean.parseBoolean(NewUserService.this.request.getParameter("subscribe-to-list"));
            this.validate();
        }

        boolean subscribeToList() {
            return this.wantsSpam;
        }

        String getUsername() {
            return this.username;
        }

        String getPassword() {
            return this.password;
        }

        private void validate() {
            if (StringUtils.isBlank((String)this.username) || StringUtils.isBlank((String)this.password)) {
                throw new BadRequestException(BAD_REQ_MSG);
            }
            if (NewUserService.this.im.getProfileManager().hasProfile(this.username)) {
                throw new BadRequestException(USER_EXISTS_MSG);
            }
        }
    }

    private static class SubscribeAction
    implements MailAction {
        private final String to;

        SubscribeAction(String to) {
            this.to = to;
        }

        @Override
        public void act(Emailer emailer) throws Exception {
            emailer.subscribeToList(this.to);
        }
    }

    private static class WelcomeAction
    implements MailAction {
        private final String to;

        WelcomeAction(String to) {
            this.to = to;
        }

        @Override
        public void act(Emailer emailer) throws Exception {
            emailer.welcome(this.to);
        }
    }
}

