/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.user;

import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.ProfileManager;
import org.intermine.util.MailUtils;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.BadRequestException;

public class RequestPswResetService
extends JSONService {
    private static final Logger LOG = Logger.getLogger(RequestPswResetService.class);

    public RequestPswResetService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected void execute() throws Exception {
        String username = this.getRequiredParameter("email");
        String redirectUrl = this.getRequiredParameter("redirectUrl");
        ProfileManager pm = this.im.getProfileManager();
        try {
            String token = pm.createPasswordChangeToken(username);
            MailUtils.emailPasswordToken(username, redirectUrl + "?token=" + token, this.webProperties);
        }
        catch (IllegalArgumentException ex) {
            throw new BadRequestException("Email " + username + " not found");
        }
    }
}

