/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.user;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.DuplicateMappingException;
import org.intermine.api.profile.Profile;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.user.ReadPreferencesService;

public class SetPreferencesService
extends ReadPreferencesService {
    private static final Set<String> BLACKLISTED_NAMES = new HashSet<String>(Arrays.asList("token", "format"));

    public SetPreferencesService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected void execute() {
        HashMap<String, String> newPrefs = new HashMap<String, String>();
        for (Object key : this.request.getParameterMap().keySet()) {
            String pname = String.valueOf(key);
            if (BLACKLISTED_NAMES.contains(pname)) continue;
            newPrefs.put(pname, this.getRequiredParameter(pname));
        }
        Profile p = this.getPermission().getProfile();
        try {
            p.getPreferences().putAll(newPrefs);
        }
        catch (DuplicateMappingException e) {
            throw new BadRequestException(e.getMessage());
        }
        super.execute();
    }
}

