/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.widget;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.web.logic.widget.config.WidgetConfig;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.output.Output;
import org.intermine.webservice.server.output.StreamedOutput;
import org.intermine.webservice.server.output.XMLFormatter;
import org.intermine.webservice.server.widget.FlatWidgetProcessor;
import org.intermine.webservice.server.widget.JSONWidgetProcessor;
import org.intermine.webservice.server.widget.WidgetProcessor;
import org.intermine.webservice.server.widget.XMLWidgetProcessor;

public class AvailableWidgetsService
extends JSONService {
    public AvailableWidgetsService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected void execute() throws Exception {
        WebConfig webConfig = InterMineContext.getWebConfig();
        Map<String, WidgetConfig> widgetDetails = webConfig.getWidgets();
        WidgetProcessor processor = this.getProcessor();
        Iterator<Map.Entry<String, WidgetConfig>> it = widgetDetails.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, WidgetConfig> pair = it.next();
            List<String> row = processor.process(pair.getKey(), pair.getValue());
            if (!this.formatIsFlatFile() && it.hasNext()) {
                row.add("");
            }
            this.output.addResultItem(row);
        }
    }

    @Override
    protected Map<String, Object> getHeaderAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.putAll(super.getHeaderAttributes());
        if (this.formatIsJSON()) {
            attributes.put("intro", "\"widgets\":[");
            attributes.put("outro", "]");
        }
        return attributes;
    }

    private WidgetProcessor getProcessor() {
        if (this.formatIsJSON()) {
            return JSONWidgetProcessor.instance();
        }
        if (this.formatIsXML()) {
            return XMLWidgetProcessor.instance();
        }
        return FlatWidgetProcessor.instance();
    }

    @Override
    protected Output makeXMLOutput(PrintWriter out, String separator) {
        ResponseUtil.setXMLHeader(this.response, "result.xml");
        return new StreamedOutput(out, new WidgetXMLFormatter());
    }

    private class WidgetXMLFormatter
    extends XMLFormatter {
        private WidgetXMLFormatter() {
        }

        @Override
        public String formatResult(List<String> resultRow) {
            return StringUtils.join(resultRow, (String)"");
        }
    }
}

