/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.widget;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.intermine.webservice.server.widget.WidgetResultProcessor;

public final class EnrichmentXMLProcessor
implements WidgetResultProcessor {
    private static final WidgetResultProcessor INSTANCE = new EnrichmentXMLProcessor();
    private static final Map<Integer, String> ELEMENTS = new HashMap<Integer, String>(){
        private static final long serialVersionUID = 5353373450297092694L;
        {
            this.put(0, "identifier");
            this.put(1, "description");
            this.put(2, "pValue");
            this.put(3, "count");
            this.put(4, "populationAnnotationCount");
        }
    };

    private EnrichmentXMLProcessor() {
    }

    public static WidgetResultProcessor instance() {
        return INSTANCE;
    }

    @Override
    public List<String> formatRow(List<Object> row) {
        StringBuffer sb = new StringBuffer("<result>");
        int i = 0;
        for (Object cell : row) {
            sb.append(this.formatCell(ELEMENTS.get(i), cell));
            ++i;
        }
        sb.append("</result>");
        return Arrays.asList(sb.toString());
    }

    private String formatCell(String name, Object contents) {
        StringBuffer sb = new StringBuffer();
        if (contents != null) {
            if (contents instanceof List) {
                for (Object o : (List)contents) {
                    sb.append(this.formatCell(name, o));
                }
            } else {
                sb.append("<" + name + ">");
                sb.append(StringEscapeUtils.escapeXml((String)contents.toString()));
                sb.append("</" + name + ">");
            }
        }
        return sb.toString();
    }
}

