/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.widget;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.types.ClassKeys;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.widget.TableWidget;
import org.intermine.web.logic.widget.config.TableWidgetConfig;
import org.intermine.web.logic.widget.config.WidgetConfig;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.widget.FlatFileWidgetResultProcessor;
import org.intermine.webservice.server.widget.TableJSONProcessor;
import org.intermine.webservice.server.widget.TableXMLProcessor;
import org.intermine.webservice.server.widget.WidgetResultProcessor;
import org.intermine.webservice.server.widget.WidgetService;
import org.intermine.webservice.server.widget.WidgetsRequestParser;
import org.intermine.webservice.server.widget.WidgetsServiceInput;

public class TableWidgetService
extends WidgetService {
    private final WidgetsRequestParser requestParser = new WidgetsRequestParser();

    public TableWidgetService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected void execute() {
        WebConfig webConfig;
        WidgetConfig widgetConfig;
        WidgetsServiceInput input = this.requestParser.getInput(this.request);
        InterMineBag imBag = this.retrieveBag(input.getBagName());
        this.addOutputListInfo(imBag);
        String type = input.getType();
        if (type != null) {
            this.addOutputInfo("type", type);
        }
        if ((widgetConfig = (webConfig = InterMineContext.getWebConfig()).getWidgets().get(input.getWidgetId())) == null || !(widgetConfig instanceof TableWidgetConfig)) {
            throw new ResourceNotFoundException("Could not find a table widget called \"" + input.getWidgetId() + "\"");
        }
        this.addOutputConfig(widgetConfig);
        String ids = input.getIds();
        String populationIds = input.getPopulationIds();
        TableWidget widget = null;
        try {
            ClassKeys classKeys = this.im.getClassKeys();
            TableWidgetConfig twc = (TableWidgetConfig)widgetConfig;
            twc.setClassKeys((Map<String, List<FieldDescriptor>>)classKeys);
            widget = twc.getWidget(imBag, null, this.im.getObjectStore(), input, ids, populationIds);
            widget.process();
            this.addOutputInfo("columns", StringUtils.join((Object[])widget.getColumns().toArray(), (String)","));
        }
        catch (ClassCastException e) {
            throw new ResourceNotFoundException("Could not find a table widget called \"" + input.getWidgetId() + "\"", e);
        }
        this.addOutputInfo("notAnalysed", Integer.toString(widget.getNotAnalysed()));
        this.addOutputPathQuery(widget, widgetConfig);
        try {
            this.addOutputResult(widget);
        }
        catch (Exception e) {
            throw new ServiceException("Could not get results.", e);
        }
    }

    @Override
    protected void addOutputConfig(WidgetConfig config) {
        super.addOutputConfig(config);
        this.addOutputInfo("columnTitle", ((TableWidgetConfig)config).getColumnTitle());
    }

    private void addOutputPathQuery(TableWidget widget, WidgetConfig config) {
        this.addOutputInfo("pathQuery", widget.getPathQuery().toJson());
        TableWidgetConfig tableWidgetConfig = (TableWidgetConfig)config;
        String pathStrings = tableWidgetConfig.getPathStrings();
        if (pathStrings.contains("[") && pathStrings.contains("]")) {
            pathStrings = pathStrings.substring(0, pathStrings.indexOf("[")) + pathStrings.substring(pathStrings.indexOf("]") + 1);
        }
        String prefix = pathStrings + ".";
        this.addOutputInfo("pathConstraint", prefix + "id");
    }

    @Override
    protected WidgetResultProcessor getProcessor() {
        if (this.formatIsJSON()) {
            return TableJSONProcessor.instance();
        }
        if (this.formatIsXML()) {
            return TableXMLProcessor.instance();
        }
        return FlatFileWidgetResultProcessor.instance();
    }
}

