/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.widget;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.intermine.webservice.server.widget.WidgetResultProcessor;

public final class TableXMLProcessor
implements WidgetResultProcessor {
    private static final WidgetResultProcessor INSTANCE = new TableXMLProcessor();

    private TableXMLProcessor() {
    }

    public static WidgetResultProcessor instance() {
        return INSTANCE;
    }

    @Override
    public List<String> formatRow(List<Object> row) {
        StringBuffer sb = new StringBuffer("<result>");
        sb.append(this.formatCell("identifier", row.get(0)));
        sb.append(this.formatCell("descriptions", row.get(1)));
        sb.append(this.formatCell("matches", row.get(4)));
        sb.append("</result>");
        return new LinkedList<String>(Arrays.asList(sb.toString()));
    }

    private String formatCell(String name, Object contents) {
        StringBuffer sb = new StringBuffer();
        if (contents instanceof List) {
            for (Object o : (List)contents) {
                sb.append(this.formatCell(name, o));
            }
        } else {
            sb.append("<" + name + ">");
            sb.append(StringEscapeUtils.escapeXml((String)contents.toString()));
            sb.append("</" + name + ">");
        }
        return sb.toString();
    }
}

