/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.widget;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.web.logic.widget.Widget;
import org.intermine.web.logic.widget.config.WidgetConfig;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.widget.WidgetResultProcessor;

public abstract class WidgetService
extends JSONService {
    private List<String> cachedFilters = null;

    public WidgetService(InterMineAPI im) {
        super(im);
    }

    protected InterMineBag retrieveBag(String bagName) {
        if (bagName == null || "".equals(bagName)) {
            return null;
        }
        Profile profile = this.getPermission().getProfile();
        InterMineBag imBag = this.im.getBagManager().getBag(profile, bagName);
        if (imBag == null) {
            throw new BadRequestException("You do not have access to a bag named " + bagName);
        }
        return imBag;
    }

    protected void addOutputAttribute(String label, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            this.addOutputInfo(label, value);
        }
    }

    protected void addOutputListInfo(InterMineBag imBag) {
        if (imBag != null) {
            this.addOutputInfo("type", imBag.getType());
            this.addOutputInfo("list", imBag.getName());
        }
        this.addOutputInfo("requestedAt", new Date().toGMTString());
    }

    protected void addOutputIdsInfo(String ids, String populationIds) {
        if (ids != null) {
            this.addOutputInfo("ids", ids);
        }
        if (populationIds != null) {
            this.addOutputInfo("populationIds", populationIds);
        }
    }

    protected void addOutputConfig(WidgetConfig config) {
        this.addOutputAttribute("title", config.getTitle());
        this.addOutputAttribute("description", config.getDescription());
    }

    protected void addOutputFilter(WidgetConfig widgetConfig, String filterSelectedValue, InterMineBag imBag, String ids) {
        this.addOutputAttribute("filterLabel", widgetConfig.getFilterLabel());
        List<String> filters = this.getFilters(widgetConfig, imBag, ids);
        if (filters != null && !filters.isEmpty()) {
            this.addOutputAttribute("filters", StringUtils.join(filters, (String)","));
            this.addOutputAttribute("filterSelectedValue", filterSelectedValue);
        }
    }

    protected void addOutputResult(Widget widget) throws Exception {
        WidgetResultProcessor processor = this.getProcessor();
        Iterator<List<Object>> it = widget.getResults().iterator();
        while (it.hasNext()) {
            List<Object> row = it.next();
            List<String> processed = processor.formatRow(row);
            if (this.formatIsJSON() && it.hasNext()) {
                processed.add("");
            }
            this.output.addResultItem(processed);
        }
    }

    protected abstract WidgetResultProcessor getProcessor();

    @Override
    protected Map<String, Object> getHeaderAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.putAll(super.getHeaderAttributes());
        if (this.formatIsJSON()) {
            attributes.put("intro", "\"results\":[");
            attributes.put("outro", "]");
        }
        return attributes;
    }

    private List<String> getFilters(WidgetConfig widgetConfig, InterMineBag imBag, String ids) {
        if (this.cachedFilters == null) {
            this.cachedFilters = widgetConfig.getFiltersValues(this.im.getObjectStore(), imBag, ids);
        }
        return this.cachedFilters;
    }

    protected String getDefaultFilterValue(WidgetConfig widgetConfig, InterMineBag imBag, String ids) {
        List<String> filters = this.getFilters(widgetConfig, imBag, ids);
        String defaultValue = null;
        if (filters != null && !filters.isEmpty()) {
            defaultValue = filters.get(0);
        }
        return defaultValue;
    }
}

