/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.commons;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dsa.iot.commons.Container;
import org.dsa.iot.dslink.util.Objects;
import org.dsa.iot.dslink.util.handler.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GuaranteedReceiver<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuaranteedReceiver.class);
    private final TimeUnit timeUnit;
    private final long delay;
    private final List<Handler<T>> list = new ArrayList<Handler<T>>();
    private ScheduledFuture<?> instantiationFut;
    private ScheduledFuture<?> loopFut;
    private T instance;
    private boolean running = true;

    public GuaranteedReceiver(long delay) {
        this(delay, false);
    }

    public GuaranteedReceiver(long delay, boolean loop) {
        this(delay, TimeUnit.SECONDS, loop);
    }

    public GuaranteedReceiver(long delay, TimeUnit unit, boolean loop) {
        if (delay <= 0L) {
            String err = "Delay must be greater than zero";
            throw new IllegalArgumentException(err);
        }
        this.delay = delay;
        this.timeUnit = unit;
        if (loop) {
            this.initializeLoop();
        }
    }

    protected abstract T instantiate() throws Exception;

    protected abstract boolean invalidateInstance(Exception var1);

    protected void onLoop(T event) {
    }

    public final void get(Handler<T> handler, boolean checked) {
        this.get(handler, checked, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void get(Handler<T> handler, boolean checked, boolean persist) {
        boolean reattempt;
        block21: {
            T tmp;
            Object stpe;
            reattempt = false;
            GuaranteedReceiver guaranteedReceiver = this;
            synchronized (guaranteedReceiver) {
                if (!this.running) {
                    if (checked) {
                        throw new IllegalStateException("Receiver shutdown");
                    }
                    return;
                }
                if (this.instance == null) {
                    if (handler != null && persist) {
                        this.list.add(handler);
                    }
                    if (this.instantiationFut != null) {
                        return;
                    }
                    stpe = GuaranteedReceiver.getSTPE();
                    InstantiationRunner runner = new InstantiationRunner();
                    this.instantiationFut = ((ScheduledThreadPoolExecutor)stpe).scheduleWithFixedDelay(runner, 0L, this.delay, this.timeUnit);
                }
            }
            stpe = this;
            synchronized (stpe) {
                tmp = this.instance;
            }
            if (tmp != null && handler != null) {
                try {
                    handler.handle(tmp);
                }
                catch (Exception e) {
                    if (this.invalidateInstance(e)) {
                        GuaranteedReceiver guaranteedReceiver2 = this;
                        synchronized (guaranteedReceiver2) {
                            this.instance = null;
                        }
                        reattempt = true;
                        break block21;
                    }
                    LOGGER.error("Unhandled exception", (Throwable)e);
                }
            } else if (tmp == null) {
                reattempt = true;
            }
        }
        if (reattempt && persist) {
            this.get(handler, checked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T shutdown() {
        T tmp;
        GuaranteedReceiver guaranteedReceiver = this;
        synchronized (guaranteedReceiver) {
            this.running = false;
        }
        if (this.loopFut != null) {
            try {
                this.loopFut.cancel(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.loopFut = null;
        }
        GuaranteedReceiver guaranteedReceiver2 = this;
        synchronized (guaranteedReceiver2) {
            tmp = this.instance;
            this.list.clear();
            this.instance = null;
        }
        this.stopRunner();
        return tmp;
    }

    private void stopRunner() {
        if (this.instantiationFut != null) {
            try {
                this.instantiationFut.cancel(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.instantiationFut = null;
        }
    }

    private void initializeLoop() {
        ScheduledThreadPoolExecutor stpe = GuaranteedReceiver.getSTPE();
        this.loopFut = stpe.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                GuaranteedReceiver.this.get(new Handler<T>(){

                    public void handle(T event) {
                        GuaranteedReceiver.this.onLoop(event);
                    }
                }, false, false);
            }
        }, 0L, this.delay, this.timeUnit);
    }

    private static ScheduledThreadPoolExecutor getSTPE() {
        return Objects.getDaemonThreadPool();
    }

    private class InstantiationRunner
    implements Runnable {
        private InstantiationRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList list;
            GuaranteedReceiver guaranteedReceiver = GuaranteedReceiver.this;
            synchronized (guaranteedReceiver) {
                try {
                    GuaranteedReceiver.this.instance = GuaranteedReceiver.this.instantiate();
                    GuaranteedReceiver.this.stopRunner();
                }
                catch (Exception e) {
                    LOGGER.debug("Failed to instantiate", (Throwable)e);
                    return;
                }
            }
            GuaranteedReceiver e = GuaranteedReceiver.this;
            synchronized (e) {
                list = new ArrayList(GuaranteedReceiver.this.list);
            }
            ScheduledThreadPoolExecutor stpe = GuaranteedReceiver.getSTPE();
            final Container doBreak = new Container();
            for (final Handler handler : list) {
                final CountDownLatch latch = new CountDownLatch(1);
                stpe.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block27: {
                            GuaranteedReceiver guaranteedReceiver;
                            boolean doRemove = true;
                            try {
                                Object inst;
                                guaranteedReceiver = GuaranteedReceiver.this;
                                synchronized (guaranteedReceiver) {
                                    inst = GuaranteedReceiver.this.instance;
                                }
                                if (inst == null) {
                                    doBreak.setValue(true);
                                    latch.countDown();
                                    return;
                                }
                                latch.countDown();
                                handler.handle(inst);
                            }
                            catch (Exception e) {
                                if (GuaranteedReceiver.this.invalidateInstance(e)) {
                                    guaranteedReceiver = GuaranteedReceiver.this;
                                    synchronized (guaranteedReceiver) {
                                        GuaranteedReceiver.this.instance = null;
                                    }
                                    doRemove = false;
                                    GuaranteedReceiver.this.get(null, false);
                                    break block27;
                                }
                                LOGGER.error("Unhandled exception", (Throwable)e);
                            }
                            finally {
                                if (doRemove) {
                                    GuaranteedReceiver guaranteedReceiver2 = GuaranteedReceiver.this;
                                    synchronized (guaranteedReceiver2) {
                                        GuaranteedReceiver.this.list.remove(handler);
                                    }
                                }
                            }
                        }
                    }
                });
                try {
                    latch.await();
                }
                catch (InterruptedException e2) {
                    throw new RuntimeException(e2);
                }
                if (!((Boolean)doBreak.getValue()).booleanValue()) continue;
                break;
            }
        }
    }
}

