/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.commons;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dsa.iot.dslink.node.Permission;
import org.dsa.iot.dslink.node.actions.Action;
import org.dsa.iot.dslink.node.actions.ActionResult;
import org.dsa.iot.dslink.node.actions.Parameter;
import org.dsa.iot.dslink.node.value.Value;
import org.dsa.iot.dslink.node.value.ValueType;
import org.dsa.iot.dslink.node.value.ValueUtils;
import org.dsa.iot.dslink.util.handler.Handler;
import org.dsa.iot.dslink.util.json.JsonArray;

public abstract class ParameterizedAction
extends Action {
    private final Map<String, ParameterInfo> params = new LinkedHashMap<String, ParameterInfo>();

    public ParameterizedAction(Permission permission) {
        super(permission, null);
    }

    public abstract void handle(ActionResult var1, Map<String, Value> var2);

    public ParameterizedAction addParameter(Parameter param) {
        if (param == null) {
            throw new NullPointerException("param");
        }
        String name = param.getName();
        ValueType type = param.getType();
        ParameterInfo copy = new ParameterInfo(name, type);
        copy.setOptional(false);
        copy.setPersistent(true);
        copy.setDefaultValue(param.getDefault());
        copy.setDescription(param.getDescription());
        copy.setPlaceHolder(param.getPlaceHolder());
        copy.setEditorType(param.getEditorType());
        this.addParameter(copy);
        return this;
    }

    public void addParameter(ParameterInfo paramInfo) {
        if (paramInfo == null) {
            throw new NullPointerException("paramInfo");
        }
        String name = paramInfo.getName();
        if (this.params.containsKey(name)) {
            String err = "Parameter name already exists: " + name;
            throw new IllegalStateException(err);
        }
        this.params.put(name, paramInfo);
        super.addParameter((Parameter)paramInfo);
    }

    public final void invoke(ActionResult actionResult) {
        if (!this.hasPermission()) {
            return;
        }
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        HashMap<String, Value> map = new HashMap<String, Value>();
        for (ParameterInfo info : this.params.values()) {
            String name = info.getName();
            Value value = actionResult.getParameter(name);
            if (!info.optional() && value == null) {
                throw new RuntimeException("Missing parameter: " + name);
            }
            if (value != null) {
                ValueUtils.checkType((String)name, (ValueType)info.getType(), (Value)value);
                Handler<Value> validator = info.getValidator();
                if (validator != null) {
                    long time = value.getTime();
                    validator.handle((Object)value);
                    value.setTime(time);
                }
                map.put(name, value);
            }
            if (info.persist()) {
                info.setDefaultValue(value);
            }
            list.add(info);
        }
        this.setParams(list);
        this.handle(actionResult, map);
    }

    public final void setParams(Collection<Parameter> newParams) {
        ((Action)this).params = new JsonArray();
        for (Parameter p : newParams) {
            super.addParameter(p);
        }
        this.postParamsUpdate();
    }

    public static class ParameterInfo
    extends Parameter {
        private boolean optional;
        private boolean persist;
        private Handler<Value> validator;

        public ParameterInfo(String name, ValueType type) {
            this(name, type, null);
        }

        public ParameterInfo(String name, ValueType type, Value def) {
            super(name, type, def);
        }

        public void setValidator(Handler<Value> validator) {
            this.validator = validator;
        }

        public Handler<Value> getValidator() {
            return this.validator;
        }

        public void setOptional(boolean optional) {
            this.optional = optional;
        }

        public boolean optional() {
            return this.optional;
        }

        public void setPersistent(boolean persist) {
            this.persist = persist;
        }

        public boolean persist() {
            return this.persist;
        }
    }
}

