/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.shared;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SharedObjects {
    private static final int MAX_CORE_POOL_SIZE = 64;
    private static final int MIN_CORE_POOL_SIZE = 16;
    private static final int CORE_POOL_FEW_PROCESSORS_THRESHOLD = 2;
    private static final int CORE_POOL_MANY_PROCESSORS_MULTIPLIER = 8;
    public static final int POOL_SIZE = SharedObjects.calculateCorePoolSize();
    private static volatile ScheduledThreadPoolExecutor THREAD_POOL;
    private static volatile ScheduledThreadPoolExecutor DAEMON_THREAD_POOL;
    private static volatile EventLoopGroup LOOP;

    private static int calculateCorePoolSize() {
        int definedSize = Integer.parseInt(System.getProperty("dsa.shared.threadPoolSize", "0"));
        if (definedSize == 0) {
            int processors = Runtime.getRuntime().availableProcessors();
            definedSize = processors <= 2 ? 16 : Math.min(64, processors * 8);
        }
        return definedSize;
    }

    public static EventLoopGroup getLoop() {
        if (LOOP == null) {
            LOOP = new NioEventLoopGroup();
        }
        return LOOP;
    }

    public static void setLoop(EventLoopGroup group) {
        LOOP = group;
    }

    public static ScheduledThreadPoolExecutor createThreadPool(int size) {
        return new ScheduledThreadPool(size);
    }

    public static ScheduledThreadPoolExecutor getThreadPool() {
        if (THREAD_POOL == null) {
            SharedObjects.setThreadPool(SharedObjects.createThreadPool(POOL_SIZE));
        }
        return THREAD_POOL;
    }

    public static void setThreadPool(ScheduledThreadPoolExecutor stpe) {
        THREAD_POOL = stpe;
    }

    public static ScheduledThreadPoolExecutor createDaemonThreadPool(int size) {
        ThreadFactory factory = SharedObjects.getDaemonFactory();
        return new ScheduledThreadPool(size, factory);
    }

    public static ScheduledThreadPoolExecutor getDaemonThreadPool() {
        if (DAEMON_THREAD_POOL == null) {
            SharedObjects.setDaemonThreadPool(SharedObjects.createDaemonThreadPool(POOL_SIZE));
        }
        return DAEMON_THREAD_POOL;
    }

    public static void setDaemonThreadPool(ScheduledThreadPoolExecutor stpe) {
        DAEMON_THREAD_POOL = stpe;
    }

    private static ThreadFactory getDaemonFactory() {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                return t;
            }
        };
    }

    protected static class ScheduledThreadPool
    extends ScheduledThreadPoolExecutor {
        public ScheduledThreadPool(int corePoolSize) {
            super(corePoolSize);
            this.configurePolicies();
        }

        public ScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory) {
            super(corePoolSize, threadFactory);
            this.configurePolicies();
        }

        private void configurePolicies() {
            this.setRemoveOnCancelPolicy(true);
            this.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        }

        @Override
        protected void afterExecute(Runnable runnable, Throwable t) {
            if (t == null && runnable instanceof Future) {
                try {
                    ((Future)((Object)runnable)).get(0L, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException | CancellationException | TimeoutException exception) {
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)e.getCause();
                    }
                    throw new RuntimeException(e.getCause());
                }
            } else if (t != null) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t);
            }
        }
    }
}

