/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authorize.builtin.webapi;

import org.iplass.mtp.auth.Permission;
import org.iplass.mtp.impl.auth.authorize.AuthorizationContext;
import org.iplass.mtp.impl.auth.authorize.builtin.AuthorizationContextCacheLogic;
import org.iplass.mtp.impl.auth.authorize.builtin.AuthorizationContextHandler;
import org.iplass.mtp.impl.auth.authorize.builtin.BuiltinAuthorizationContext;
import org.iplass.mtp.impl.auth.authorize.builtin.TenantAuthorizeContext;
import org.iplass.mtp.impl.auth.authorize.builtin.webapi.AllPermissionWebApiAuthContext;
import org.iplass.mtp.impl.auth.authorize.builtin.webapi.WebApiAuthContextCacheLogic;
import org.iplass.mtp.webapi.permission.WebApiPermission;

public class WebApiAuthContextHandler
extends AuthorizationContextHandler {
    private static final Class<?>[] PERM_TYPE = new Class[]{WebApiPermission.class};
    private static final AllPermissionWebApiAuthContext DEFAULT = new AllPermissionWebApiAuthContext(false);

    public Class<? extends Permission>[] permissionType() {
        return PERM_TYPE;
    }

    protected String cacheNamespace() {
        return "mtp.auth.builtin.webapi";
    }

    protected String contextName(Permission permission) {
        return ((WebApiPermission)permission).getWebApiName();
    }

    protected String toMetaDataPath(String contextName) {
        return "/webapi/" + contextName;
    }

    protected AuthorizationContextCacheLogic newAuthorizeContextCacheLogic(TenantAuthorizeContext tac) {
        return new WebApiAuthContextCacheLogic(tac);
    }

    public BuiltinAuthorizationContext get(String contextName, TenantAuthorizeContext tac) {
        BuiltinAuthorizationContext webapiContext;
        if (contextName.length() == 0) {
            contextName = "/";
        }
        if ((webapiContext = super.get(contextName, tac)) == null) {
            String currentWebapiName = contextName;
            while (currentWebapiName.contains("/") && webapiContext == null) {
                currentWebapiName = currentWebapiName.substring(0, currentWebapiName.lastIndexOf("/"));
                webapiContext = super.get(currentWebapiName + "/*", tac);
            }
            if (webapiContext == null) {
                webapiContext = super.get("*", tac);
            }
        }
        return webapiContext;
    }

    protected AuthorizationContext defaultAuthorizationContext(String contextName, TenantAuthorizeContext tac) {
        return DEFAULT;
    }
}

