/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;
import org.iplass.mtp.impl.auth.oauth.AccessTokenCredential;
import org.iplass.mtp.impl.auth.oauth.token.AccessToken;

public class AccessTokenAccountHandle
implements AccountHandle {
    private static final long serialVersionUID = 9109210238979237297L;
    public static final String AUTHED_BY_ACCESS_TOKEN = "authedByAccessToken";
    public static final String GRANTED_SCOPES = "oauthGrantedScopes";
    public static final String CLIENT_ID = "oauthClientId";
    private String unmodifiableUniqueKey;
    private Map<String, Object> attributeMap;
    private int authenticationProviderIndex;
    private AccessToken accessToken;

    public AccessTokenAccountHandle() {
    }

    public AccessTokenAccountHandle(String unmodifiableUniqueKey, AccessToken accessToken, String policyName) {
        this.unmodifiableUniqueKey = unmodifiableUniqueKey;
        this.accessToken = accessToken;
        this.getAttributeMap().put(AUTHED_BY_ACCESS_TOKEN, Boolean.TRUE);
        if (accessToken != null) {
            this.getAttributeMap().put(GRANTED_SCOPES, new ArrayList<String>(accessToken.getGrantedScopes()));
            this.getAttributeMap().put(CLIENT_ID, accessToken.getClientId());
        }
        this.getAttributeMap().put("accountPolicy", policyName);
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public boolean isAccountLocked() {
        return false;
    }

    public boolean isExpired() {
        return false;
    }

    public boolean isInitialLogin() {
        return false;
    }

    public Credential getCredential() {
        AccessTokenCredential c = new AccessTokenCredential();
        c.setId(this.unmodifiableUniqueKey);
        return c;
    }

    public String getUnmodifiableUniqueKey() {
        return this.unmodifiableUniqueKey;
    }

    public Map<String, Object> getAttributeMap() {
        if (this.attributeMap == null) {
            this.attributeMap = new HashMap<String, Object>();
        }
        return this.attributeMap;
    }

    public void setAuthenticationProviderIndex(int authenticationProviderIndex) {
        this.authenticationProviderIndex = authenticationProviderIndex;
    }

    public int getAuthenticationProviderIndex() {
        return this.authenticationProviderIndex;
    }
}

