/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth;

import java.util.List;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.CredentialUpdateException;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;
import org.iplass.mtp.impl.auth.authenticate.AccountManagementModule;
import org.iplass.mtp.impl.auth.authenticate.AuthenticationProvider;
import org.iplass.mtp.impl.auth.authenticate.AuthenticationProviderBase;
import org.iplass.mtp.impl.auth.authenticate.UserEntityResolver;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.AuthenticationPolicyService;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.MetaAuthenticationPolicy;
import org.iplass.mtp.impl.auth.oauth.AccessTokenAccountHandle;
import org.iplass.mtp.impl.auth.oauth.AccessTokenCredential;
import org.iplass.mtp.impl.auth.oauth.OAuthAuthorizationService;
import org.iplass.mtp.impl.auth.oauth.token.AccessToken;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceRegistry;

public class AccessTokenAuthenticationProvider
extends AuthenticationProviderBase {
    private AccessTokenAccountManagementModule amm = new AccessTokenAccountManagementModule();
    private OAuthAuthorizationService authorizationService = (OAuthAuthorizationService)ServiceRegistry.getRegistry().getService(OAuthAuthorizationService.class);
    private AuthenticationPolicyService authPolicyService = (AuthenticationPolicyService)ServiceRegistry.getRegistry().getService(AuthenticationPolicyService.class);
    private Class<? extends Credential> credentialTypeForTrust;
    private Class<? extends AccountHandle> accountHandleClassForTrust;

    public void setCredentialTypeForTrust(Class<? extends Credential> credentialTypeForTrust) {
        this.credentialTypeForTrust = credentialTypeForTrust;
    }

    public void setAccountHandleClassForTrust(Class<? extends AccountHandle> accountHandleClassForTrust) {
        this.accountHandleClassForTrust = accountHandleClassForTrust;
    }

    public Class<? extends Credential> getCredentialType() {
        return AccessTokenCredential.class;
    }

    protected Class<? extends Credential> getCredentialTypeForTrust() {
        return this.credentialTypeForTrust;
    }

    protected Class<? extends AccountHandle> getAccountHandleClassForTrust() {
        return this.accountHandleClassForTrust;
    }

    public void inited(AuthService service, Config config) {
        super.inited(service, config);
        this.setUserEntityResolver(new AccessTokenUserEntityResolver(this.getUserEntityResolver()));
    }

    public void destroyed() {
    }

    public void cleanupData() {
    }

    public AccountHandle login(Credential credential) {
        if (credential instanceof AccessTokenCredential) {
            AccessTokenCredential cre = (AccessTokenCredential)credential;
            if (cre.getToken() == null) {
                throw new IllegalArgumentException("specify token");
            }
            AccessToken token = this.authorizationService.getAccessTokenStore().getAccessToken(cre.getToken());
            if (token == null) {
                return null;
            }
            if (token.getExpiresIn() <= 0L) {
                return null;
            }
            UserEntityResolver uer = this.getUserEntityResolver();
            User user = token.getUser();
            String oid = user.getValue(uer.getUnmodifiableUniqueKeyProperty()).toString();
            MetaAuthenticationPolicy.AuthenticationPolicyRuntime pol = this.authPolicyService.getOrDefault(user.getAccountPolicy());
            if (pol == null) {
                return null;
            }
            return new AccessTokenAccountHandle(oid, token, pol.getMetaData().getName());
        }
        return null;
    }

    public void logout(AccountHandle user) {
    }

    public AccountManagementModule getAccountManagementModule() {
        return this.amm;
    }

    public class AccessTokenUserEntityResolver
    implements UserEntityResolver {
        private UserEntityResolver actual;

        private AccessTokenUserEntityResolver(UserEntityResolver actual) {
            this.actual = actual;
        }

        public void inited(AuthService service, AuthenticationProvider provider) {
        }

        public User searchUser(AccountHandle account) {
            AccessTokenAccountHandle atah = (AccessTokenAccountHandle)account;
            return atah.getAccessToken().getUser();
        }

        public String getUnmodifiableUniqueKeyProperty() {
            return this.actual.getUnmodifiableUniqueKeyProperty();
        }

        public UserEntityResolver getActual() {
            return this.actual;
        }
    }

    private class AccessTokenAccountManagementModule
    implements AccountManagementModule {
        private AccessTokenAccountManagementModule() {
        }

        public boolean canCreate() {
            return false;
        }

        public boolean canUpdate() {
            return false;
        }

        public boolean canRemove() {
            return true;
        }

        public boolean canRestore() {
            return false;
        }

        public boolean canPurge() {
            return false;
        }

        public boolean canUpdateCredential() {
            return false;
        }

        public boolean canResetCredential() {
            return false;
        }

        public void create(User user) {
        }

        public void afterCreate(User user) {
        }

        public void update(User user, List<String> updateProperties) {
        }

        public void remove(User user) {
            UserEntityResolver uer = AccessTokenAuthenticationProvider.this.getUserEntityResolver();
            AccessTokenAuthenticationProvider.this.authorizationService.getAccessTokenStore().revokeTokenByUserOid(user.getValue(uer.getUnmodifiableUniqueKeyProperty()).toString());
        }

        public void restore(User user) {
        }

        public void purge(User user) {
        }

        public void updateCredential(Credential oldCredential, Credential newCredential) throws CredentialUpdateException {
        }

        public void resetCredential(Credential credential) throws CredentialUpdateException {
        }

        public boolean canResetLockoutStatus() {
            return false;
        }

        public void resetLockoutStatus(String accountId) {
        }
    }
}

