/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.oauth.definition.ClientType;
import org.iplass.mtp.auth.oauth.definition.GrantType;
import org.iplass.mtp.auth.oauth.definition.OAuthClientDefinition;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenService;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthAuthorization;
import org.iplass.mtp.impl.auth.oauth.OAuthAuthorizationService;
import org.iplass.mtp.impl.auth.oauth.OAuthClientCredentialHandler;
import org.iplass.mtp.impl.auth.oauth.OAuthRuntimeException;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaOAuthClient
extends BaseRootMetaData
implements DefinableMetaData<OAuthClientDefinition> {
    private static final long serialVersionUID = -3395174355560173705L;
    private static Logger logger = LoggerFactory.getLogger((String)"mtp.auth.oauth");
    private String authorizationServerId;
    private ClientType clientType;
    private List<String> redirectUris;
    private String sectorIdentifierUri;
    private List<GrantType> grantTypes;
    private String clientUri;
    private String logoUri;
    private List<String> contacts;
    private String tosUri;
    private String policyUri;

    public String getClientUri() {
        return this.clientUri;
    }

    public void setClientUri(String clientUri) {
        this.clientUri = clientUri;
    }

    public String getLogoUri() {
        return this.logoUri;
    }

    public void setLogoUri(String logoUri) {
        this.logoUri = logoUri;
    }

    public List<String> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<String> contacts) {
        this.contacts = contacts;
    }

    public String getTosUri() {
        return this.tosUri;
    }

    public void setTosUri(String tosUri) {
        this.tosUri = tosUri;
    }

    public String getPolicyUri() {
        return this.policyUri;
    }

    public void setPolicyUri(String policyUri) {
        this.policyUri = policyUri;
    }

    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public String getSectorIdentifierUri() {
        return this.sectorIdentifierUri;
    }

    public void setSectorIdentifierUri(String sectorIdentifierUri) {
        this.sectorIdentifierUri = sectorIdentifierUri;
    }

    public List<GrantType> getGrantTypes() {
        return this.grantTypes;
    }

    public void setGrantTypes(List<GrantType> grantTypes) {
        this.grantTypes = grantTypes;
    }

    public ClientType getClientType() {
        return this.clientType;
    }

    public void setClientType(ClientType clientType) {
        this.clientType = clientType;
    }

    public String getAuthorizationServerId() {
        return this.authorizationServerId;
    }

    public void setAuthorizationServerId(String authorizationServerId) {
        this.authorizationServerId = authorizationServerId;
    }

    public OAuthClientRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new OAuthClientRuntime();
    }

    public MetaOAuthClient copy() {
        return (MetaOAuthClient)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    public void applyConfig(OAuthClientDefinition def) {
        this.name = def.getName();
        this.description = def.getDescription();
        this.displayName = def.getDisplayName();
        this.localizedDisplayNameList = I18nUtil.toMeta(def.getLocalizedDisplayNameList());
        if (def.getAuthorizationServer() != null) {
            OAuthAuthorizationService oauthService = (OAuthAuthorizationService)ServiceRegistry.getRegistry().getService(OAuthAuthorizationService.class);
            this.authorizationServerId = ((MetaOAuthAuthorization.OAuthAuthorizationRuntime)oauthService.getRuntimeByName(def.getAuthorizationServer())).getMetaData().getId();
        } else {
            this.authorizationServerId = null;
        }
        this.clientType = def.getClientType();
        this.redirectUris = def.getRedirectUris() != null ? new ArrayList<String>(def.getRedirectUris()) : null;
        this.sectorIdentifierUri = def.getSectorIdentifierUri();
        this.grantTypes = def.getGrantTypes() != null ? new ArrayList<GrantType>(def.getGrantTypes()) : null;
        this.clientUri = def.getClientUri();
        this.logoUri = def.getLogoUri();
        this.contacts = def.getContacts() != null ? new ArrayList<String>(def.getContacts()) : null;
        this.tosUri = def.getTosUri();
        this.policyUri = def.getPolicyUri();
    }

    public OAuthClientDefinition currentConfig() {
        MetaOAuthAuthorization.OAuthAuthorizationRuntime oauthRuntime;
        OAuthClientDefinition def = new OAuthClientDefinition();
        def.setName(this.name);
        def.setDescription(this.description);
        def.setDisplayName(this.displayName);
        def.setLocalizedDisplayNameList(I18nUtil.toDef((List)this.localizedDisplayNameList));
        if (this.authorizationServerId != null && (oauthRuntime = (MetaOAuthAuthorization.OAuthAuthorizationRuntime)((OAuthAuthorizationService)ServiceRegistry.getRegistry().getService(OAuthAuthorizationService.class)).getRuntimeById(this.authorizationServerId)) != null) {
            def.setAuthorizationServer(oauthRuntime.getMetaData().getName());
        }
        def.setClientType(this.clientType);
        if (this.redirectUris != null) {
            def.setRedirectUris(new ArrayList<String>(this.redirectUris));
        }
        def.setSectorIdentifierUri(this.sectorIdentifierUri);
        if (this.grantTypes != null) {
            def.setGrantTypes(new ArrayList<GrantType>(this.grantTypes));
        }
        def.setClientUri(this.clientUri);
        def.setLogoUri(this.logoUri);
        if (this.contacts != null) {
            def.setContacts(new ArrayList<String>(this.contacts));
        }
        def.setTosUri(this.tosUri);
        def.setPolicyUri(this.policyUri);
        return def;
    }

    public class OAuthClientRuntime
    extends BaseMetaDataRuntime {
        private OAuthAuthorizationService serverService = (OAuthAuthorizationService)ServiceRegistry.getRegistry().getService(OAuthAuthorizationService.class);
        private OAuthClientCredentialHandler ch = (OAuthClientCredentialHandler)((AuthTokenService)ServiceRegistry.getRegistry().getService(AuthTokenService.class)).getHandler("OC");
        private String sectorId;

        public OAuthClientRuntime() {
            try {
                if (MetaOAuthClient.this.redirectUris == null || MetaOAuthClient.this.redirectUris.size() == 0) {
                    throw new IllegalStateException("redirectUris  must be specified");
                }
                for (String ru : MetaOAuthClient.this.redirectUris) {
                    try {
                        new URI(ru);
                    }
                    catch (URISyntaxException e) {
                        throw new IllegalStateException("redirectUris must valid uri:" + ru, e);
                    }
                }
                this.sectorId = this.genSectorId();
            }
            catch (RuntimeException e) {
                this.setIllegalStateException(e);
            }
        }

        private String genSectorId() {
            String targetHost = null;
            if (MetaOAuthClient.this.sectorIdentifierUri != null) {
                try {
                    targetHost = new URI(MetaOAuthClient.this.sectorIdentifierUri).getHost();
                }
                catch (URISyntaxException e) {
                    throw new IllegalStateException("sectorIdentifierUri must valid uri", e);
                }
            } else if (MetaOAuthClient.this.redirectUris != null) {
                for (String ru : MetaOAuthClient.this.redirectUris) {
                    try {
                        String host = new URI(ru).getHost();
                        if (targetHost == null) {
                            targetHost = host;
                            continue;
                        }
                        if (targetHost.equals(host)) continue;
                        throw new IllegalStateException("if set multi-domain redirectUris, sectorIdentifierUri must specify");
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return targetHost;
        }

        public MetaOAuthClient getMetaData() {
            return MetaOAuthClient.this;
        }

        public MetaOAuthAuthorization.OAuthAuthorizationRuntime getAuthorizationServer() {
            return (MetaOAuthAuthorization.OAuthAuthorizationRuntime)this.serverService.getRuntimeById(MetaOAuthClient.this.authorizationServerId);
        }

        public Credential generateCredential() {
            if (MetaOAuthClient.this.clientType == ClientType.PUBLIC) {
                throw new OAuthRuntimeException("Public client can not generate credential.");
            }
            return this.ch.generateCredential(MetaOAuthClient.this.getName());
        }

        public boolean validateCredential(Credential cre, boolean allowPublicClient) {
            if (MetaOAuthClient.this.clientType == ClientType.PUBLIC) {
                if (allowPublicClient) {
                    if (!cre.getId().equals(MetaOAuthClient.this.getName())) {
                        if (logger.isWarnEnabled()) {
                            logger.warn(MetaOAuthClient.this.getName() + ",publicClientValidate,fail");
                        }
                        return false;
                    }
                    return true;
                }
                if (logger.isWarnEnabled()) {
                    logger.warn(MetaOAuthClient.this.getName() + ",publicClientValidate,fail");
                }
                return false;
            }
            return this.ch.validateCredential(cre, MetaOAuthClient.this.getName());
        }

        public void deleteOldCredential() {
            this.ch.deleteOldCredential(MetaOAuthClient.this.getName());
        }

        public String selectValidRedirectUri(String redirectUri) {
            if (redirectUri == null) {
                return null;
            }
            if (MetaOAuthClient.this.redirectUris == null) {
                return null;
            }
            for (String ru : MetaOAuthClient.this.redirectUris) {
                if (!ru.equals(redirectUri)) continue;
                return ru;
            }
            return null;
        }

        public String sectorIdentifier() {
            if (this.sectorId == null) {
                throw new NullPointerException("sectorIdentifier is null");
            }
            return this.sectorId;
        }
    }
}

