/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.command;

import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;
import org.iplass.mtp.impl.auth.oauth.AccessTokenAccountHandle;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthAuthorization;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthClient;
import org.iplass.mtp.impl.auth.oauth.OAuthClientService;
import org.iplass.mtp.impl.auth.oauth.OAuthRuntimeException;
import org.iplass.mtp.impl.auth.oauth.token.AccessToken;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;
import org.iplass.mtp.webapi.definition.StateType;

@WebApi(name="oauth/userinfo", accepts={RequestType.REST_FORM}, methods={MethodType.GET, MethodType.POST}, checkXRequestedWithHeader=false, state=StateType.STATELESS, responseType="application/json", supportBearerToken=true, oauthScopes={"openid"})
@CommandClass(name="mtp/oauth/UserInfoCommand", displayName="OpenIDConnect1.0 UserInfo Endpoint")
public class UserInfoCommand
implements Command {
    static final String STAT_SUCCESS = "SUCCESS";
    private OAuthClientService clientService = (OAuthClientService)ServiceRegistry.getRegistry().getService(OAuthClientService.class);

    public String execute(RequestContext request) {
        AuthContextHolder ach = AuthContextHolder.getAuthContext();
        AccountHandle ah = ach.getUserContext().getAccount();
        if (!(ah instanceof AccessTokenAccountHandle)) {
            throw new OAuthRuntimeException("not authed by AccessToken:" + ah);
        }
        AccessToken token = ((AccessTokenAccountHandle)ah).getAccessToken();
        MetaOAuthClient.OAuthClientRuntime client = (MetaOAuthClient.OAuthClientRuntime)this.clientService.getRuntimeByName(token.getClientId());
        if (client == null) {
            throw new OAuthRuntimeException("invalid client_id:" + token.getClientId());
        }
        MetaOAuthAuthorization.OAuthAuthorizationRuntime authServer = client.getAuthorizationServer();
        Map userInfo = (Map)AuthContext.doPrivileged(() -> authServer.userInfo(token, client));
        Response.ResponseBuilder res = Response.ok().type(MediaType.APPLICATION_JSON_TYPE.withCharset("UTF-8")).entity((Object)userInfo);
        request.setAttribute("result", (Object)res);
        return STAT_SUCCESS;
    }
}

